/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.basic.BasicSawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

@NothingNullByDefault
public class SawmillRecipeSerializer
implements RecipeSerializer<BasicSawmillRecipe> {
    private final StreamCodec<RegistryFriendlyByteBuf, BasicSawmillRecipe> streamCodec;
    private final MapCodec<BasicSawmillRecipe> codec;

    public SawmillRecipeSerializer(Function4<ItemStackIngredient, ItemStack, ItemStack, Double, BasicSawmillRecipe> factory) {
        Codec chanceCodec = Codec.DOUBLE.validate(d -> d > 0.0 && d <= 1.0 ? DataResult.success((Object)d) : DataResult.error(() -> "Expected secondaryChance to be greater than zero, and less than or equal to one. Found " + d));
        MapCodec secondaryChanceFieldBase = chanceCodec.optionalFieldOf("secondary_chance");
        MapCodec mainOutputFieldBase = ItemStack.CODEC.optionalFieldOf("main_output");
        RecordCodecBuilder secondaryOutputField = ItemStack.CODEC.optionalFieldOf("secondary_output").forGetter(BasicSawmillRecipe::getSecondaryOutputRaw);
        this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("input").forGetter(SawmillRecipe::getInput), SerializerHelper.oneRequired(secondaryOutputField, mainOutputFieldBase, BasicSawmillRecipe::getMainOutputRaw), (App)secondaryOutputField, SerializerHelper.dependentOptionality(secondaryOutputField, secondaryChanceFieldBase, sawmillRecipe -> {
            double secondaryChance = sawmillRecipe.getSecondaryChance();
            return secondaryChance == 0.0 ? Optional.empty() : Optional.of(secondaryChance);
        })).apply((Applicative)instance, (input, mainOutput, secondaryOutput, secondChance) -> (BasicSawmillRecipe)factory.apply(input, (Object)mainOutput.orElse(ItemStack.EMPTY), (Object)secondaryOutput.orElse(ItemStack.EMPTY), (Object)secondChance.orElse(0.0))));
        this.streamCodec = StreamCodec.composite(ItemStackIngredient.STREAM_CODEC, SawmillRecipe::getInput, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, recipe -> recipe.getMainOutputRaw().orElse(ItemStack.EMPTY), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, recipe -> recipe.getSecondaryOutputRaw().orElse(ItemStack.EMPTY), (StreamCodec)ByteBufCodecs.DOUBLE, SawmillRecipe::getSecondaryChance, factory);
    }

    public MapCodec<BasicSawmillRecipe> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BasicSawmillRecipe> streamCodec() {
        return this.streamCodec;
    }
}

