/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPITags;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.ISidedChemicalHandler;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.StackedWasteBarrel;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.proxy.ProxyChemicalHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityRadioactiveWasteBarrel
extends TileEntityMekanism
implements IConfigurable {
    private long lastProcessTick;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="barrel")
    StackedWasteBarrel chemicalTank;
    @Nullable
    private IChemicalTank belowTank;
    private boolean resolvedBelowTank;
    private int processTicks;
    private List<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> chemicalHandlerBelow = Collections.emptyList();

    public TileEntityRadioactiveWasteBarrel(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.RADIOACTIVE_WASTE_BARREL, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(this.facingSupplier);
        this.chemicalTank = StackedWasteBarrel.create(this, listener);
        builder.addTank(this.chemicalTank, RelativeSide.TOP, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.level.getGameTime() > this.lastProcessTick) {
            this.lastProcessTick = this.level.getGameTime();
            if (MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get() > 0L && !this.chemicalTank.isEmpty() && !this.chemicalTank.getStack().is(MekanismAPITags.Chemicals.WASTE_BARREL_DECAY_BLACKLIST) && ++this.processTicks >= MekanismConfig.general.radioactiveWasteBarrelProcessTicks.get()) {
                this.processTicks = 0;
                this.chemicalTank.shrinkStack(MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get(), Action.EXECUTE);
            }
            if (this.getActive()) {
                IChemicalTank below;
                if (this.chemicalHandlerBelow.isEmpty()) {
                    this.chemicalHandlerBelow = List.of(Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.below(), Direction.UP, ConstantPredicates.ALWAYS_TRUE, () -> {
                        this.resolvedBelowTank = false;
                        this.belowTank = null;
                    }));
                }
                if ((below = this.getBelowTank()) == null) {
                    ChemicalUtil.emit(this.chemicalHandlerBelow, this.chemicalTank);
                } else {
                    ChemicalUtil.emit(this.chemicalHandlerBelow, this.chemicalTank, Math.min(below.getNeeded(), this.chemicalTank.getCapacity()));
                }
            }
        }
        return sendUpdatePacket;
    }

    @Nullable
    private IChemicalTank getBelowTank() {
        if (!this.resolvedBelowTank) {
            ProxyChemicalHandler chemicalHandler;
            ISidedChemicalHandler iSidedChemicalHandler;
            this.resolvedBelowTank = true;
            IChemicalHandler belowHandler = (IChemicalHandler)this.chemicalHandlerBelow.getFirst().getCapability();
            if (belowHandler instanceof ProxyChemicalHandler && (iSidedChemicalHandler = (chemicalHandler = (ProxyChemicalHandler)belowHandler).getInternalHandler()) instanceof TileEntityRadioactiveWasteBarrel) {
                TileEntityRadioactiveWasteBarrel barrel = (TileEntityRadioactiveWasteBarrel)iSidedChemicalHandler;
                this.belowTank = barrel.chemicalTank;
            }
        }
        return this.belowTank;
    }

    public StackedWasteBarrel getChemicalTank() {
        return this.chemicalTank;
    }

    public double getChemicalScale() {
        return (double)this.chemicalTank.getStored() / (double)this.chemicalTank.getCapacity();
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            Level world = this.getLevel();
            if (world != null) {
                world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("chemical", (Tag)this.chemicalTank.serializeNBT(provider));
        updateTag.putInt("progress", this.processTicks);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent(tag, "chemical", nbt -> this.chemicalTank.deserializeNBT(provider, (CompoundTag)nbt));
        NBTUtils.setIntIfPresent(tag, "progress", val -> {
            this.processTicks = val;
        });
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.chemicalTank.getStored(), this.chemicalTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }
}

