/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config.slot;

import java.util.List;
import java.util.function.Supplier;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.HeatSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;

public interface IProxiedSlotInfo
extends ISlotInfo {

    @FunctionalInterface
    public static interface ProxySlotInfoCreator<T> {
        public IProxiedSlotInfo create(boolean var1, boolean var2, Supplier<List<T>> var3);
    }

    public static class InventoryProxy
    extends InventorySlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IInventorySlot>> slotSupplier;

        public InventoryProxy(boolean canInput, boolean canOutput, Supplier<List<IInventorySlot>> slotSupplier) {
            super(canInput, canOutput, new IInventorySlot[0]);
            this.slotSupplier = slotSupplier;
        }

        @Override
        public List<IInventorySlot> getSlots() {
            return this.slotSupplier.get();
        }
    }

    public static class HeatProxy
    extends HeatSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IHeatCapacitor>> capacitorSupplier;

        public HeatProxy(boolean canInput, boolean canOutput, Supplier<List<IHeatCapacitor>> capacitorSupplier) {
            super(canInput, canOutput, new IHeatCapacitor[0]);
            this.capacitorSupplier = capacitorSupplier;
        }

        @Override
        public List<IHeatCapacitor> getHeatCapacitors() {
            return this.capacitorSupplier.get();
        }
    }

    public static class ChemicalProxy
    extends ChemicalSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IChemicalTank>> tankSupplier;

        public ChemicalProxy(boolean canInput, boolean canOutput, Supplier<List<IChemicalTank>> tankSupplier) {
            super(canInput, canOutput, new IChemicalTank[0]);
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<IChemicalTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class FluidProxy
    extends FluidSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IExtendedFluidTank>> tankSupplier;

        public FluidProxy(boolean canInput, boolean canOutput, Supplier<List<IExtendedFluidTank>> tankSupplier) {
            super(canInput, canOutput, new IExtendedFluidTank[0]);
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<IExtendedFluidTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class EnergyProxy
    extends EnergySlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IEnergyContainer>> containerSupplier;

        public EnergyProxy(boolean canInput, boolean canOutput, Supplier<List<IEnergyContainer>> containerSupplier) {
            super(canInput, canOutput, new IEnergyContainer[0]);
            this.containerSupplier = containerSupplier;
        }

        @Override
        public List<IEnergyContainer> getContainers() {
            return this.containerSupplier.get();
        }
    }
}

