/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityLaserTractorBeam
extends TileEntityLaserReceptor {
    public TileEntityLaserTractorBeam(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.LASER_TRACTOR_BEAM, pos, state);
    }

    @Override
    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create(BasicEnergyContainer.notExternal, BasicEnergyContainer.internalOnly, this, listener);
        builder.addContainer(this.energyContainer);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        for (int slotX = 0; slotX < 9; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                OutputInventorySlot slot = OutputInventorySlot.at(listener, 8 + slotX * 18, 16 + slotY * 18);
                builder.addSlot(slot);
                slot.setSlotType(ContainerSlotType.NORMAL);
            }
        }
        return builder.build();
    }

    @Override
    protected void handleBreakBlock(BlockState state, ServerLevel level, BlockPos hitPos, Player player, ItemStack tool) {
        List<ItemStack> drops = WorldUtils.getDrops(state, level, hitPos, WorldUtils.getTileEntity((BlockGetter)level, hitPos), (Entity)player, tool);
        CommonWorldTickHandler.fallbackItemCollector = drops::add;
        this.breakBlock(state, level, hitPos, tool);
        CommonWorldTickHandler.fallbackItemCollector = null;
        if (!drops.isEmpty()) {
            BlockPos dropPos = null;
            Direction opposite = null;
            List<IInventorySlot> inventorySlots = this.getInventorySlots(null);
            for (ItemStack drop : drops) {
                if ((drop = InventoryUtils.insertItem(inventorySlots, drop, Action.EXECUTE, AutomationType.INTERNAL)).isEmpty()) continue;
                if (dropPos == null) {
                    Direction direction = this.getDirection();
                    dropPos = this.worldPosition.relative(direction, 2);
                    opposite = direction.getOpposite();
                }
                Block.popResourceFromFace((Level)level, dropPos, opposite, (ItemStack)drop);
            }
        }
    }

    @Override
    protected boolean handleHitItem(ItemEntity entity) {
        ItemStack stack = entity.getItem();
        stack = InventoryUtils.insertItem(this.getInventorySlots(null), stack, Action.EXECUTE, AutomationType.INTERNAL);
        if (stack.isEmpty()) {
            entity.discard();
        }
        return true;
    }

    @ComputerMethod
    int getSlotCount() {
        return this.getSlots();
    }

    @ComputerMethod
    ItemStack getItemInSlot(int slot) throws ComputerException {
        int slots = this.getSlotCount();
        if (slot < 0 || slot >= slots) {
            throw new ComputerException("Slot: '%d' is out of bounds, as this laser amplifier only has '%d' slots (zero indexed).", slot, slots);
        }
        return this.getStackInSlot(slot);
    }
}

