/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.energy.DynamicStrictEnergyHandler;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityUniversalCable
extends TileEntityTransmitter
implements IComputerTile {
    private final EnergyHandlerManager energyHandlerManager = new EnergyHandlerManager(direction -> {
        UniversalCable cable = this.getTransmitter();
        if (direction != null && cable.getConnectionTypeRaw(direction) == ConnectionType.NONE || cable.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return cable.getEnergyContainers(direction);
    }, new DynamicStrictEnergyHandler(this::getEnergyContainers, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public TileEntityUniversalCable(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(this.energyHandlerManager);
    }

    protected UniversalCable createTransmitter(Holder<Block> blockProvider) {
        return new UniversalCable(blockProvider, this);
    }

    public UniversalCable getTransmitter() {
        return (UniversalCable)super.getTransmitter();
    }

    @Override
    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return BlockStateHelper.copyStateData(current, switch (tier) {
            case BaseTier.BASIC -> MekanismBlocks.BASIC_UNIVERSAL_CABLE;
            case BaseTier.ADVANCED -> MekanismBlocks.ADVANCED_UNIVERSAL_CABLE;
            case BaseTier.ELITE -> MekanismBlocks.ELITE_UNIVERSAL_CABLE;
            case BaseTier.ULTIMATE -> MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE;
            default -> null;
        });
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            EnergyNetwork network = (EnergyNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.putLong("energy", network.energyContainer.getEnergy());
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapabilities(EnergyCompatUtils.getLoadedEnergyCapabilities(), side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    @Override
    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilitiesAll(EnergyCompatUtils.getLoadedEnergyCapabilities());
        } else {
            this.invalidateCapabilities();
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "UniversalCable";
    }

    @ComputerMethod
    long getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        UniversalCable cable = this.getTransmitter();
        return cable.hasTransmitterNetwork() ? ((EnergyNetwork)cable.getTransmitterNetwork()).getCapacity() : cable.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - this.getBuffer();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return MathUtils.divideToLevel(this.getBuffer(), this.getCapacity());
    }
}

