/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.attribute.ChemicalFuel;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.lib.distribution.Target;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@NothingNullByDefault
public class ChemicalUtil {
    private ChemicalUtil() {
    }

    public static ItemStack getFullChemicalTank(ChemicalTankTier tier, @NotNull Holder<Chemical> chemical) {
        return ChemicalUtil.getFilledVariant(ChemicalUtil.getEmptyChemicalTank(tier), chemical);
    }

    private static Holder<Item> getEmptyChemicalTank(ChemicalTankTier tier) {
        return (switch (tier) {
            default -> throw new MatchException(null, null);
            case ChemicalTankTier.BASIC -> MekanismBlocks.BASIC_CHEMICAL_TANK;
            case ChemicalTankTier.ADVANCED -> MekanismBlocks.ADVANCED_CHEMICAL_TANK;
            case ChemicalTankTier.ELITE -> MekanismBlocks.ELITE_CHEMICAL_TANK;
            case ChemicalTankTier.ULTIMATE -> MekanismBlocks.ULTIMATE_CHEMICAL_TANK;
            case ChemicalTankTier.CREATIVE -> MekanismBlocks.CREATIVE_CHEMICAL_TANK;
        }).getItemHolder();
    }

    public static ItemStack getFilledVariant(Holder<Item> toFill, Holder<Chemical> provider) {
        return ChemicalUtil.getFilledVariant(new ItemStack(toFill), provider);
    }

    public static ItemStack getFilledVariant(ItemStack toFill, Holder<Chemical> provider) {
        IMekanismChemicalHandler attachment = ContainerType.CHEMICAL.createHandler(toFill);
        if (attachment != null) {
            for (IChemicalTank tank : attachment.getChemicalTanks(null)) {
                long amount = tank.getCapacity();
                tank.setStack(new ChemicalStack(provider, amount));
            }
        }
        return toFill;
    }

    public static int getRGBDurabilityForDisplay(ItemStack stack) {
        ChemicalStack chemicalStack = StorageUtils.getFirstChemicalFromAttachment(stack);
        return chemicalStack.isEmpty() ? 0 : chemicalStack.getChemicalColorRepresentation();
    }

    public static boolean hasAnyChemical(ItemStack stack) {
        return ChemicalUtil.hasChemical(stack, ConstantPredicates.alwaysTrue());
    }

    public static boolean hasChemicalOfType(ItemStack stack, Chemical type) {
        return ChemicalUtil.hasChemical(stack, s -> s.is(type));
    }

    public static boolean hasChemical(ItemStack stack, Predicate<ChemicalStack> validityCheck) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
        if (handler != null) {
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty() || !validityCheck.test(chemicalStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, IChemicalTank tank) {
        ChemicalUtil.emit(targets, tank, tank.getCapacity());
    }

    public static void emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, IChemicalTank tank, long maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0L) {
            tank.extract(ChemicalUtil.emit(targets, ChemicalStack.EMPTY, tank, maxOutput), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static long emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, @NotNull ChemicalStack stack) {
        return ChemicalUtil.emit(targets, stack, null, Long.MAX_VALUE);
    }

    private static long emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, @NotNull ChemicalStack stack, @UnknownNullability IChemicalTank tank, long maxOutput) {
        if (stack.isEmpty() && tank == null) {
            return 0L;
        }
        if (targets.isEmpty()) {
            return 0L;
        }
        Target target = null;
        for (BlockCapabilityCache<IChemicalHandler, Direction> capability : targets) {
            IChemicalHandler handler = (IChemicalHandler)capability.getCapability();
            if (handler == null) continue;
            if (stack.isEmpty() && (stack = tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL)).isEmpty()) {
                return 0L;
            }
            if (!ChemicalUtil.canInsert(handler, stack)) continue;
            if (target == null) {
                target = new ChemicalHandlerTarget(targets.size());
            }
            target.addHandler(handler);
        }
        return EmitUtils.sendToAcceptors(target, stack.getAmount(), stack.copy());
    }

    public static boolean canInsert(IChemicalHandler handler, @NotNull ChemicalStack stack) {
        return handler.insertChemical(stack, Action.SIMULATE).getAmount() < stack.getAmount();
    }

    public static long hydrogenEnergyDensity() {
        ChemicalFuel fuel = (ChemicalFuel)MekanismChemicals.HYDROGEN.getData(IMekanismDataMapTypes.INSTANCE.chemicalFuel());
        return fuel == null ? 0L : fuel.energyDensity();
    }

    public static long hydrogenEnergyPerTick() {
        ChemicalFuel fuel = (ChemicalFuel)MekanismChemicals.HYDROGEN.getData(IMekanismDataMapTypes.INSTANCE.chemicalFuel());
        return fuel == null ? 0L : fuel.energyPerTick();
    }

    public static Chemical chemical(ChemicalBuilder builder, @Nullable Integer colorRepresentation) {
        if (colorRepresentation == null) {
            return new Chemical(builder);
        }
        final int color = colorRepresentation;
        return new Chemical(builder){

            @Override
            public int getColorRepresentation() {
                return color;
            }
        };
    }
}

