/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.extender;

import dev.technici4n.moderndynamics.MdBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class MachineExtenderBlockEntity
extends MdBlockEntity {
    private static int registeredApis = 0;
    private final boolean[] inApiQuery = new boolean[registeredApis * (1 + Direction.values().length)];
    private final BlockCapabilityCache[] apiCaches = new BlockCapabilityCache[registeredApis * (1 + Direction.values().length)];
    boolean inNeighborUpdate = false;
    private final ICapabilityInvalidationListener invalidationListener = () -> {
        if (this.isRemoved()) {
            return false;
        }
        this.invalidateCapabilities();
        return true;
    };

    private static int getDirectionIndex(@Nullable Direction direction) {
        return direction == null ? 0 : 1 + direction.ordinal();
    }

    private static int getCacheIndex(int apiId, @Nullable Direction direction) {
        return apiId * 7 + MachineExtenderBlockEntity.getDirectionIndex(direction);
    }

    public static <A> void forwardApi(RegisterCapabilitiesEvent evt, BlockEntityType<MachineExtenderBlockEntity> bet, BlockCapability<A, Direction> lookup) {
        int apiId = registeredApis++;
        evt.registerBlockEntity(lookup, bet, (sideExtender, direction) -> {
            int cacheIndex = MachineExtenderBlockEntity.getCacheIndex(apiId, direction);
            if (sideExtender.inApiQuery[cacheIndex]) {
                return null;
            }
            sideExtender.inApiQuery[cacheIndex] = true;
            try {
                BlockCapabilityCache cache = sideExtender.apiCaches[cacheIndex];
                if (cache == null) {
                    BlockPos queryPos = sideExtender.getBlockPos().below();
                    Level patt0$temp = sideExtender.getLevel();
                    if (patt0$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt0$temp;
                        sideExtender.apiCaches[cacheIndex] = cache = BlockCapabilityCache.create((BlockCapability)lookup, (ServerLevel)serverLevel, (BlockPos)queryPos, (Object)direction);
                    } else {
                        Object object = sideExtender.getLevel().getCapability(lookup, queryPos, direction);
                        return object;
                    }
                }
                Object object = cache.getCapability();
                return object;
            }
            finally {
                sideExtender.inApiQuery[cacheIndex] = false;
            }
        });
    }

    public MachineExtenderBlockEntity(BlockEntityType<?> bet, BlockPos pos, BlockState state) {
        super(bet, pos, state);
    }

    public void clearRemoved() {
        super.clearRemoved();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.registerCapabilityListener(this.getBlockPos().below(), this.invalidationListener);
        }
    }

    @Override
    public void toTag(CompoundTag tag, HolderLookup.Provider registries) {
    }

    @Override
    public void fromTag(CompoundTag tag, HolderLookup.Provider registries) {
    }

    @Override
    public void toClientTag(CompoundTag tag, RegistryAccess registries) {
    }

    @Override
    public void fromClientTag(CompoundTag tag, RegistryAccess registries) {
    }
}

