/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.init;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.InhibitorAttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.debug.DebugToolItem;
import dev.technici4n.moderndynamics.init.MdAttachments;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.pipe.PipeItem;
import dev.technici4n.moderndynamics.util.MdId;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class MdItems {
    public static final PipeItem ITEM_PIPE = new PipeItem(MdBlocks.ITEM_PIPE);
    public static final PipeItem FLUID_PIPE = new PipeItem(MdBlocks.FLUID_PIPE);
    public static final PipeItem LV_CABLE = new PipeItem(MdBlocks.LV_CABLE);
    public static final PipeItem MV_CABLE = new PipeItem(MdBlocks.MV_CABLE);
    public static final PipeItem HV_CABLE = new PipeItem(MdBlocks.HV_CABLE);
    public static final PipeItem EV_CABLE = new PipeItem(MdBlocks.EV_CABLE);
    public static final PipeItem SUPERCONDUCTOR_CABLE = new PipeItem(MdBlocks.SUPERCONDUCTOR_CABLE);
    public static final AttachmentItem ATTRACTOR = new IoAttachmentItem(MdAttachments.ATTRACTOR, IoAttachmentType.ATTRACTOR);
    public static final AttachmentItem EXTRACTOR = new IoAttachmentItem(MdAttachments.EXTRACTOR, IoAttachmentType.EXTRACTOR);
    public static final AttachmentItem FILTER = new IoAttachmentItem(MdAttachments.FILTER, IoAttachmentType.FILTER);
    public static final AttachmentItem INHIBITOR = new InhibitorAttachmentItem(MdAttachments.INHIBITOR);
    public static final BlockItem MACHINE_EXTENDER = new BlockItem((Block)MdBlocks.MACHINE_EXTENDER, new Item.Properties());
    public static final Item WRENCH = new Item(new Item.Properties().stacksTo(1));
    public static final DebugToolItem DEBUG_TOOL = new DebugToolItem();
    public static final PipeItem[] ALL_PIPES = new PipeItem[]{ITEM_PIPE, FLUID_PIPE, LV_CABLE, MV_CABLE, HV_CABLE, EV_CABLE, SUPERCONDUCTOR_CABLE};
    public static final AttachmentItem[] ALL_ATTACHMENTS = new AttachmentItem[]{ATTRACTOR, EXTRACTOR, FILTER, INHIBITOR};

    public static void init() {
        for (PipeItem pipeItem : ALL_PIPES) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)MdId.of(pipeItem.getBlock().id), (Object)((Object)pipeItem));
        }
        for (AttachmentItem attachmentItem : ALL_ATTACHMENTS) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)MdId.of(attachmentItem.attachment.id), (Object)((Object)attachmentItem));
        }
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)MdId.of(MdBlocks.MACHINE_EXTENDER.id), (Object)MACHINE_EXTENDER);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)MdId.of("wrench"), (Object)WRENCH);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)MdId.of("debug_tool"), (Object)((Object)DEBUG_TOOL));
    }
}

