/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.energy;

import com.google.common.primitives.Ints;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.energy.EnergyHost;
import dev.technici4n.moderndynamics.network.energy.SimpleEnergyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyCache
extends NetworkCache<EnergyHost, EnergyCache> {
    private SimpleEnergyStorage energyStorage = null;

    public EnergyCache(ServerLevel level, List<NetworkNode<EnergyHost, EnergyCache>> nodes) {
        super(level, nodes);
    }

    public int getEnergyStored() {
        this.combine();
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        this.combine();
        return this.energyStorage.getMaxEnergyStored();
    }

    public int insert(int maxAmount, boolean simulate) {
        this.combine();
        return this.energyStorage.receiveEnergy(maxAmount, simulate);
    }

    public int extract(int maxAmount, boolean simulate) {
        this.combine();
        return this.energyStorage.extractEnergy(maxAmount, simulate);
    }

    @Override
    protected void doCombine() {
        int energy = 0;
        int maxEnergy = 0;
        for (NetworkNode node : this.nodes) {
            EnergyHost host = (EnergyHost)node.getHost();
            energy += host.getEnergy();
            maxEnergy += host.getMaxEnergy();
        }
        this.energyStorage = new SimpleEnergyStorage(maxEnergy, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.energyStorage.setEnergy(energy);
    }

    @Override
    protected void doSeparate() {
        this.nodes.sort(Comparator.comparingLong(node -> ((EnergyHost)node.getHost()).getMaxEnergy()));
        int remainingNodes = this.nodes.size();
        for (NetworkNode node2 : this.nodes) {
            EnergyHost host = (EnergyHost)node2.getHost();
            int nodeEnergy = Math.min(host.getMaxEnergy(), this.energyStorage.getEnergyStored() / remainingNodes);
            host.setEnergy(nodeEnergy);
            this.energyStorage.reduceEnergyStored(nodeEnergy);
            --remainingNodes;
        }
        this.energyStorage = null;
    }

    @Override
    public void doTick() {
        this.combine();
        ArrayList<IEnergyStorage> storages = new ArrayList<IEnergyStorage>();
        for (NetworkNode node : this.nodes) {
            if (!((EnergyHost)node.getHost()).isTicking()) continue;
            ((EnergyHost)node.getHost()).addEnergyStorages(storages);
        }
        int remainingCapacity = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
        this.energyStorage.addEnergyStored(EnergyCache.transferForTargets(IEnergyStorage::extractEnergy, storages, remainingCapacity));
        this.energyStorage.reduceEnergyStored(EnergyCache.transferForTargets(IEnergyStorage::receiveEnergy, storages, this.energyStorage.getEnergyStored()));
    }

    /*
     * WARNING - void declaration
     */
    public static int transferForTargets(TransferOperation operation, List<IEnergyStorage> targets, int maxAmount) {
        void var5_10;
        ArrayList<EnergyTarget> sortableTargets = new ArrayList<EnergyTarget>(targets.size());
        for (IEnergyStorage iEnergyStorage : targets) {
            sortableTargets.add(new EnergyTarget(iEnergyStorage));
        }
        Collections.shuffle(sortableTargets);
        for (EnergyTarget energyTarget : sortableTargets) {
            energyTarget.simulationResult = operation.transfer(energyTarget.target, maxAmount, true);
        }
        sortableTargets.sort(Comparator.comparingLong(t -> t.simulationResult));
        int transferredAmount = 0;
        boolean bl = false;
        while (var5_10 < sortableTargets.size()) {
            EnergyTarget target = (EnergyTarget)sortableTargets.get((int)var5_10);
            int remainingTargets = sortableTargets.size() - var5_10;
            int remainingAmount = maxAmount - transferredAmount;
            int targetMaxAmount = Ints.saturatedCast((long)(remainingAmount / remainingTargets));
            transferredAmount += operation.transfer(target.target, targetMaxAmount, false);
            ++var5_10;
        }
        return transferredAmount;
    }

    @Override
    public void appendDebugInfo(StringBuilder out) {
        super.appendDebugInfo(out);
        if (this.energyStorage == null) {
            out.append("no energy storage\n");
        } else {
            out.append("energy = ").append(this.energyStorage.getEnergyStored()).append("\n");
            out.append("max energy = ").append(this.energyStorage.getMaxEnergyStored()).append("\n");
        }
    }

    public static interface TransferOperation {
        public int transfer(IEnergyStorage var1, int var2, boolean var3);
    }

    private static class EnergyTarget {
        final IEnergyStorage target;
        int simulationResult;

        EnergyTarget(IEnergyStorage target) {
            this.target = target;
        }
    }
}

