/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import dev.technici4n.moderndynamics.util.FluidVariant;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public final class FluidRenderUtil {
    private FluidRenderUtil() {
    }

    public static TextureAtlasSprite getStillSprite(FluidVariant variant) {
        FluidStack stack;
        if (variant.isBlank()) {
            return null;
        }
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)variant.getFluid());
        ResourceLocation texture = renderProps.getStillTexture(stack = variant.toStack(1));
        if (texture == null) {
            return null;
        }
        Function atlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        return (TextureAtlasSprite)atlas.apply(texture);
    }

    public static int getTint(FluidVariant variant) {
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)variant.getFluid());
        FluidStack stack = variant.toStack(1);
        return renderProps.getTintColor(stack);
    }
}

