/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.technici4n.moderndynamics.ModernDynamics;
import dev.technici4n.moderndynamics.util.ItemVariantImpl;
import dev.technici4n.moderndynamics.util.TransferVariant;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface ItemVariant
extends TransferVariant<Item> {
    public static final Codec<ItemVariant> CODEC = ExtraCodecs.optionalEmptyMap((Codec)ItemStack.SINGLE_ITEM_CODEC.xmap(ItemVariant::of, ItemVariant::toStack)).xmap(o -> o.orElse(ItemVariant.blank()), fv -> fv.isBlank() ? Optional.empty() : Optional.of(fv));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemVariant> STREAM_CODEC = ItemStack.STREAM_CODEC.map(ItemVariant::of, ItemVariant::toStack);

    public static ItemVariant blank() {
        return ItemVariant.of((ItemLike)Items.AIR);
    }

    public static ItemVariant of(ItemStack stack) {
        return ItemVariantImpl.of(stack);
    }

    public static ItemVariant of(ItemLike item) {
        return ItemVariantImpl.of(item.asItem());
    }

    public boolean matches(ItemStack var1);

    default public Item getItem() {
        return (Item)this.getObject();
    }

    default public ItemStack toStack() {
        return this.toStack(1);
    }

    public ItemStack toStack(int var1);

    public int getMaxStackSize();

    @Override
    default public Tag toNbt(HolderLookup.Provider registries) {
        return (Tag)CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public static ItemVariant fromNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        return CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)ModernDynamics.LOGGER).error(arg_0)).orElse(ItemVariant.blank());
    }

    @Override
    default public void toPacket(RegistryFriendlyByteBuf buf) {
        STREAM_CODEC.encode((Object)buf, (Object)this);
    }

    public static ItemVariant fromPacket(RegistryFriendlyByteBuf buf) {
        return (ItemVariant)STREAM_CODEC.decode((Object)buf);
    }
}

