/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity.client;

import com.buuz135.industrial.entity.InfinityTridentEntity;
import com.buuz135.industrial.entity.client.InfinityTridentModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class InfinityTridentRenderer
extends EntityRenderer<InfinityTridentEntity> {
    public static final ModelLayerLocation TRIDENT_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"infinity_trident"), "main");
    public static final ResourceLocation TRIDENT = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/item/infinity_trident.png");
    private final InfinityTridentModel tridentModel;

    public InfinityTridentRenderer(EntityRendererProvider.Context p_174286_) {
        super(p_174286_);
        this.tridentModel = new InfinityTridentModel(p_174286_.bakeLayer(TRIDENT_LAYER));
    }

    public void render(InfinityTridentEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot()) + 90.0f));
        matrixStackIn.translate(0.5, -0.5, -0.5);
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferIn, (RenderType)RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entityIn)), (boolean)false, (boolean)entityIn.isEnchanted());
        this.tridentModel.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(InfinityTridentEntity entity) {
        return TRIDENT;
    }
}

