/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinityDrill
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 30;

    public ItemInfinityDrill(TitaniumTab group) {
        super("infinity_drill", group, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return Items.DIAMOND_PICKAXE.supportsEnchantment(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), enchantment) || Items.DIAMOND_SHOVEL.supportsEnchantment(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), enchantment);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState blockIn) {
        return Items.DIAMOND_PICKAXE.isCorrectToolForDrops(stack, blockIn) || Items.DIAMOND_SHOVEL.isCorrectToolForDrops(stack, blockIn);
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        HitResult rayTraceResult;
        if (entityLiving instanceof Player && (rayTraceResult = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)entityLiving, (double)16.0, (float)0.0f)).getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)rayTraceResult;
            Direction facing = blockResult.getDirection();
            InfinityTier currentTier = ItemInfinityDrill.getSelectedTier(stack);
            Pair<BlockPos, BlockPos> area = this.getArea(pos, facing, currentTier, true);
            ArrayList totalDrops = new ArrayList();
            BlockPos.betweenClosed((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                if (this.enoughFuel(stack) && worldIn.getBlockEntity(blockPos) == null && worldIn instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)worldIn;
                    if (entityLiving instanceof ServerPlayer && !worldIn.isEmptyBlock(blockPos) && BlockUtils.canBlockBeBroken(worldIn, blockPos, entityLiving.getStringUUID())) {
                        BlockState tempState = worldIn.getBlockState(blockPos);
                        Block block = tempState.getBlock();
                        if (!tempState.is(BlockTags.MINEABLE_WITH_PICKAXE) && !tempState.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
                            return;
                        }
                        if (tempState.getDestroySpeed((BlockGetter)worldIn, blockPos) < 0.0f) {
                            return;
                        }
                        int xp = EnchantmentHelper.processBlockExperience((ServerLevel)serverLevel, (ItemStack)stack, (int)block.getExpDrop(tempState, (LevelAccessor)worldIn, blockPos, worldIn.getBlockEntity(blockPos), (Entity)entityLiving, stack));
                        if (block.onDestroyedByPlayer(tempState, worldIn, blockPos, (Player)entityLiving, true, tempState.getFluidState())) {
                            block.destroy((LevelAccessor)worldIn, blockPos, tempState);
                            Block.getDrops((BlockState)tempState, (ServerLevel)((ServerLevel)worldIn), (BlockPos)blockPos, null, (Entity)((Player)entityLiving), (ItemStack)stack).forEach(itemStack -> {
                                boolean combined = false;
                                for (ItemStack drop : totalDrops) {
                                    if (!ItemStack.isSameItemSameComponents((ItemStack)drop, (ItemStack)itemStack) || drop.getCount() + itemStack.getCount() > itemStack.getMaxStackSize()) continue;
                                    drop.setCount(drop.getCount() + itemStack.getCount());
                                    combined = true;
                                    break;
                                }
                                if (!combined) {
                                    totalDrops.add(itemStack);
                                }
                            });
                            block.popExperience((ServerLevel)worldIn, blockPos, xp);
                            this.consumeFuel(stack);
                        }
                    }
                }
            });
            totalDrops.forEach(itemStack -> Block.popResource((Level)worldIn, (BlockPos)entityLiving.blockPosition(), (ItemStack)itemStack));
            worldIn.getEntitiesOfClass(ExperienceOrb.class, new AABB(((BlockPos)area.getLeft()).getCenter(), ((BlockPos)area.getRight()).getCenter()).inflate(1.0)).forEach(entityXPOrb -> entityXPOrb.teleportTo((double)entityLiving.blockPosition().getX(), (double)entityLiving.blockPosition().getY(), (double)entityLiving.blockPosition().getZ()));
        }
        return super.mineBlock(stack, worldIn, state, pos, entityLiving);
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "infinity_drill", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_SHOVEL)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())}), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD)), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }
}

