/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import java.util.List;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AetherConfig {
    public static final ModConfigSpec STARTUP_SPEC;
    public static final Startup STARTUP;
    public static final ModConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    public static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair startupSpecPair = new ModConfigSpec.Builder().configure(Startup::new);
        STARTUP_SPEC = (ModConfigSpec)startupSpecPair.getRight();
        STARTUP = (Startup)startupSpecPair.getLeft();
        Pair serverSpecPair = new ModConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ModConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
        Pair commonSpecPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Startup {
        public final ModConfigSpec.ConfigValue<Boolean> enable_trivia;

        public Startup(ModConfigSpec.Builder builder) {
            builder.push("Gui");
            this.enable_trivia = builder.comment("Adds random trivia and tips to the bottom of loading screens").translation("config.aether.client.gui.enable_trivia").define("Enables random trivia", true);
            builder.pop();
        }
    }

    public static class Server {
        public final ModConfigSpec.ConfigValue<Boolean> enable_bed_explosions;
        public final ModConfigSpec.ConfigValue<Boolean> tools_debuff;
        public final ModConfigSpec.ConfigValue<Boolean> edible_ambrosium;
        public final ModConfigSpec.ConfigValue<Boolean> berry_bush_consistency;
        public final ModConfigSpec.ConfigValue<Boolean> crystal_leaves_consistency;
        public final ModConfigSpec.ConfigValue<Boolean> healing_gummy_swets;
        public final ModConfigSpec.ConfigValue<Integer> hammer_of_kingbdogz_cooldown;
        public final ModConfigSpec.ConfigValue<Integer> cloud_staff_cooldown;
        public final ModConfigSpec.ConfigValue<Integer> maximum_life_shards;
        public final ModConfigSpec.ConfigValue<Boolean> require_gloves;
        public final ModConfigSpec.ConfigValue<Boolean> spawn_golden_feather;
        public final ModConfigSpec.ConfigValue<Boolean> spawn_valkyrie_cape;
        public final ModConfigSpec.ConfigValue<Boolean> generate_tall_grass;
        public final ModConfigSpec.ConfigValue<Boolean> generate_holiday_tree_always;
        public final ModConfigSpec.ConfigValue<Boolean> generate_holiday_tree_seasonally;
        public final ModConfigSpec.ConfigValue<Boolean> balance_invisibility_cloak;
        public final ModConfigSpec.ConfigValue<Integer> invisibility_visibility_time;
        public final ModConfigSpec.ConfigValue<Boolean> sun_altar_whitelist;
        public final ModConfigSpec.ConfigValue<List<? extends String>> sun_altar_dimensions;
        public final ModConfigSpec.ConfigValue<Boolean> spawn_in_aether;
        public final ModConfigSpec.ConfigValue<Boolean> disable_aether_portal;
        public final ModConfigSpec.ConfigValue<Boolean> disable_falling_to_overworld;
        public final ModConfigSpec.ConfigValue<Boolean> disable_eternal_day;
        public final ModConfigSpec.ConfigValue<Boolean> normal_length_aether_time;
        public final ModConfigSpec.ConfigValue<Boolean> sync_aether_time;
        public final ModConfigSpec.ConfigValue<String> portal_destination_dimension_ID;
        public final ModConfigSpec.ConfigValue<String> portal_return_dimension_ID;

        public Server(ModConfigSpec.Builder builder) {
            builder.push("Gameplay");
            this.enable_bed_explosions = builder.comment("Vanilla's beds will explode in the Aether").translation("config.aether.server.gameplay.enable_bed_explosions").define("Beds explode", false);
            this.tools_debuff = builder.comment("Tools that aren't from the Aether will mine Aether blocks slower than tools that are from the Aether").translation("config.aether.server.gameplay.tools_debuff").define("Debuff non-Aether tools", true);
            this.edible_ambrosium = builder.comment("Ambrosium Shards can be eaten to restore a half heart of health").translation("config.aether.server.gameplay.edible_ambrosium").define("Ambrosium Shards are edible", true);
            this.berry_bush_consistency = builder.comment("Makes Berry Bushes and Bush Stems behave consistently with Sweet Berry Bushes").translation("config.aether.server.gameplay.berry_bush_consistency").define("Berry Bush consistency", false);
            this.crystal_leaves_consistency = builder.comment("Makes Crystal Fruit Leaves behave consistently with Sweet Berry Bushes").translation("config.aether.server.gameplay.crystal_leaves_consistency").define("Crystal Fruit Leaves consistency", false);
            this.healing_gummy_swets = builder.comment("Gummy Swets when eaten restore full health instead of full hunger").translation("config.aether.server.gameplay.healing_gummy_swets").define("Gummy Swets restore health", false);
            this.maximum_life_shards = builder.comment("Determines the limit of the amount of Life Shards a player can consume to increase their health").translation("config.aether.server.gameplay.maximum_life_shards").define("Maximum consumable Life Shards", (Object)10);
            this.hammer_of_kingbdogz_cooldown = builder.comment("Determines the cooldown in ticks for the Hammer of Kingbdogz's ability").translation("config.aether.server.gameplay.hammer_of_kingbdogz_cooldown").define("Cooldown for the Hammer of Kingbdogz projectile", (Object)50);
            this.cloud_staff_cooldown = builder.comment("Determines the cooldown in ticks for the Cloud Staff's ability").translation("config.aether.server.gameplay.cloud_staff_cooldown").define("Cooldown for the Cloud Staff", (Object)40);
            this.require_gloves = builder.comment("Makes armor abilities depend on wearing the respective gloves belonging to an armor set").translation("config.aether.server.gameplay.require_gloves").define("Require gloves for set abilities", true);
            builder.pop();
            builder.push("Loot");
            this.spawn_golden_feather = builder.comment("Allows the Golden Feather to spawn in the Silver Dungeon loot table").translation("config.aether.server.loot.spawn_golden_feather").define("Golden Feather in loot", false);
            this.spawn_valkyrie_cape = builder.comment("Allows the Valkyrie Cape to spawn in the Silver Dungeon loot table").translation("config.aether.server.loot.spawn_valkyrie_cape").define("Valkyrie Cape in loot", true);
            builder.pop();
            builder.push("World Generation");
            this.generate_tall_grass = builder.comment("Determines whether the Aether should generate Tall Grass blocks on terrain or not").translation("config.aether.server.world_generation.generate_tall_grass").define("Generate Tall Grass in the Aether", true);
            this.generate_holiday_tree_always = builder.comment("Determines whether Holiday Trees should always be able to generate when exploring new chunks in the Aether, if true, this overrides 'Generate Holiday Trees seasonally'").translation("config.aether.server.world_generation.generate_holiday_tree_always").define("Generate Holiday Trees always", false);
            this.generate_holiday_tree_seasonally = builder.comment("Determines whether Holiday Trees should be able to generate during the time frame of December and January when exploring new chunks in the Aether, only works if 'Generate Holiday Trees always' is set to false").translation("config.aether.server.world_generation.generate_holiday_tree_seasonally").define("Generate Holiday Trees seasonally", true);
            builder.pop();
            builder.push("Multiplayer");
            this.balance_invisibility_cloak = builder.comment("Makes the Invisibility Cloak more balanced in PVP by disabling equipment invisibility temporarily after attacks").translation("config.aether.server.multiplayer.balance_invisibility_cloak").define("Balance Invisibility Cloak for PVP", false);
            this.invisibility_visibility_time = builder.comment("Sets the time in ticks that it takes for the player to become fully invisible again after attacking when wearing an Invisibility Cloak; only works with 'Balance Invisibility Cloak for PVP'").translation("config.aether.server.multiplayer.invisibility_visibility_time").define("Invisibility Cloak visibility timer", (Object)50);
            this.sun_altar_whitelist = builder.comment("Makes it so that only whitelisted users or anyone with permission level 4 can use the Sun Altar on a server").translation("config.aether.server.multiplayer.sun_altar_whitelist").define("Only whitelisted users access Sun Altars", false);
            this.sun_altar_dimensions = builder.comment("Configures what dimensions are able to have their time changed by the Sun Altar").translation("config.aether.server.multiplayer.sun_altar_dimensions").defineList("Configure Sun Altar dimensions", List.of("aether:the_aether"), () -> "", s -> s instanceof String);
            builder.pop();
            builder.push("Modpack");
            this.spawn_in_aether = builder.comment("Spawns the player in the Aether dimension; this is best enabled alongside other modpack configuration to avoid issues").translation("config.aether.server.modpack.spawn_in_aether").define("Spawns the player in the Aether", false);
            this.disable_aether_portal = builder.comment("Prevents the Aether Portal from being created normally in the mod").translation("config.aether.server.modpack.disable_aether_portal").define("Disables Aether Portal creation", false);
            this.disable_falling_to_overworld = builder.comment("Prevents the player from falling back to the Overworld when they fall out of the Aether").translation("config.aether.server.modpack.disable_falling_to_overworld").define("Disables falling into the Overworld", false);
            this.disable_eternal_day = builder.comment("Removes eternal day so that the Aether has a normal daylight cycle even before defeating the Sun Spirit").translation("config.aether.server.modpack.disable_eternal_day").define("Disables eternal day", false);
            this.normal_length_aether_time = builder.comment("Sets the Aether's time cycle to be the same length as the Overworld's").translation("config.aether.server.modpack.normal_length_aether_time").define("Overworld-length Aether time cycle", false);
            this.sync_aether_time = builder.comment("Syncs the Aether's time cycle to the Overworld's").translation("config.aether.server.modpack.sync_aether_time").define("Syncs time cycles", false);
            this.portal_destination_dimension_ID = builder.comment("Sets the ID of the dimension that the Aether Portal will send the player to").translation("config.aether.server.modpack.portal_destination_dimension_ID").define("Sets portal destination dimension", (Object)AetherDimensions.AETHER_LEVEL.location().toString());
            this.portal_return_dimension_ID = builder.comment("Sets the ID of the dimension that the Aether Portal will return the player to").translation("config.aether.server.modpack.portal_return_dimension_ID").define("Sets portal return dimension", (Object)Level.OVERWORLD.location().toString());
            builder.pop();
        }
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Boolean> use_default_accessories_menu;
        public final ModConfigSpec.ConfigValue<Boolean> start_with_portal;
        public final ModConfigSpec.ConfigValue<Boolean> enable_startup_loot;
        public final ModConfigSpec.ConfigValue<Boolean> reposition_slider_message;
        public final ModConfigSpec.ConfigValue<Boolean> repeat_sun_spirit_dialogue;
        public final ModConfigSpec.ConfigValue<Boolean> show_patreon_message;
        public final ModConfigSpec.ConfigValue<Boolean> add_temporary_freezing_automatically;
        public final ModConfigSpec.ConfigValue<Boolean> add_ruined_portal_automatically;
        public final ModConfigSpec.ConfigValue<Boolean> enable_immersive_portals_compatibility;

        public Common(ModConfigSpec.Builder builder) {
            builder.push("Gameplay");
            this.use_default_accessories_menu = builder.gameRestart().comment("Use the default Accessories menu instead of the Aether's Accessories Menu. WARNING: Do not enable this without emptying your equipped accessories").translation("config.aether.common.gameplay.use_default_accessories_menu").define("Use default Accessories' menu", false);
            this.start_with_portal = builder.comment("On world creation, the player is given an Aether Portal Frame item to automatically go to the Aether with").translation("config.aether.common.gameplay.start_with_portal").define("Gives player Aether Portal Frame item", false);
            this.enable_startup_loot = builder.comment("When the player enters the Aether, they are given a Book of Lore and Golden Parachutes as starting loot").translation("config.aether.common.gameplay.enable_startup_loot").define("Gives starting loot on entry", true);
            this.reposition_slider_message = builder.comment("Moves the message for when a player attacks the Slider with an incorrect item to be above the hotbar instead of in chat").translation("config.aether.common.gameplay.reposition_slider_message").define("Reposition attack message above hotbar", false);
            this.repeat_sun_spirit_dialogue = builder.comment("Determines whether the Sun Spirit's dialogue when meeting him should play through every time you meet him").translation("config.aether.common.gameplay.repeat_sun_spirit_dialogue").define("Repeat Sun Spirit's battle dialogue", true);
            this.show_patreon_message = builder.comment("Determines if a message that links The Aether mod's Patreon should show").translation("config.aether.common.gameplay.show_patreon_message").define("Show Patreon message", true);
            builder.pop();
            builder.push("Data Pack");
            this.add_temporary_freezing_automatically = builder.worldRestart().comment("Sets the Aether Temporary Freezing data pack to be added to new worlds automatically").translation("config.aether.common.data_pack.add_temporary_freezing_automatically").define("Add Temporary Freezing automatically", false);
            this.add_ruined_portal_automatically = builder.worldRestart().comment("Sets the Aether Ruined Portals data pack to be added to new worlds automatically").translation("config.aether.common.data_pack.add_ruined_portal_automatically").define("Add Ruined Portals automatically", false);
            builder.pop();
            builder.push("Modpack");
            this.enable_immersive_portals_compatibility = builder.comment("Enables code and data pack features used for modifying Aether Portals when Immersive Portals is installed").translation("config.aether.common.modpack.enable_immersive_portals_compatibility").define("Enables Immersive Portals compatibility", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<Boolean> legacy_models;
        public final ModConfigSpec.ConfigValue<Boolean> disable_aether_skybox;
        public final ModConfigSpec.ConfigValue<Boolean> disable_clouds;
        public final ModConfigSpec.ConfigValue<Boolean> colder_lightmap;
        public final ModConfigSpec.ConfigValue<Boolean> green_sunset;
        public final ModConfigSpec.ConfigValue<Boolean> enable_silver_hearts;
        public final ModConfigSpec.ConfigValue<Boolean> disable_accessory_button;
        public final ModConfigSpec.ConfigValue<Boolean> disable_skins_button;
        public final ModConfigSpec.ConfigValue<Integer> portal_text_y;
        public final ModConfigSpec.ConfigValue<Integer> button_inventory_x;
        public final ModConfigSpec.ConfigValue<Integer> button_inventory_y;
        public final ModConfigSpec.ConfigValue<Integer> button_creative_x;
        public final ModConfigSpec.ConfigValue<Integer> button_creative_y;
        public final ModConfigSpec.ConfigValue<Integer> button_accessories_x;
        public final ModConfigSpec.ConfigValue<Integer> button_accessories_y;
        public final ModConfigSpec.ConfigValue<Integer> layout_perks_x;
        public final ModConfigSpec.ConfigValue<Integer> layout_perks_y;
        public final ModConfigSpec.ConfigValue<Boolean> enable_hammer_cooldown_overlay;
        public final ModConfigSpec.ConfigValue<Boolean> blue_aercloud_bounce_sfx;
        public final ModConfigSpec.ConfigValue<Integer> music_backup_min_delay;
        public final ModConfigSpec.ConfigValue<Integer> music_backup_max_delay;
        public final ModConfigSpec.ConfigValue<Boolean> disable_music_manager;
        public final ModConfigSpec.ConfigValue<Boolean> disable_aether_boss_music;
        public final ModConfigSpec.ConfigValue<Boolean> disable_aether_menu_music;
        public final ModConfigSpec.ConfigValue<Boolean> disable_vanilla_world_preview_menu_music;
        public final ModConfigSpec.ConfigValue<Boolean> disable_aether_world_preview_menu_music;
        public final ModConfigSpec.ConfigValue<Boolean> enable_server_button;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("Rendering");
            this.legacy_models = builder.comment("Changes Zephyr and Aerwhale rendering to use their old models from the b1.7.3 version of the mod").translation("config.aether.client.rendering.legacy_models").define("Switches to legacy mob models", false);
            this.disable_aether_skybox = builder.comment("Disables the Aether's custom skybox in case you have a shader that is incompatible with custom skyboxes").translation("config.aether.client.rendering.disable_aether_skybox").define("Disables Aether custom skybox", false);
            this.disable_clouds = builder.comment("Disables the cloud rendering in the Aether").translation("config.aether.client.rendering.disable_clouds").define("Disables Aether's clouds", false);
            this.colder_lightmap = builder.comment("Removes warm-tinting of the lightmap in the Aether, giving the lighting a colder feel").translation("config.aether.client.rendering.colder_lightmap").define("Makes lightmap colder", false);
            this.green_sunset = builder.comment("Enables a green-tinted sunrise and sunset in the Aether, similar to the original mod").translation("config.aether.client.rendering.green_sunset").define("Enables green sunrise/sunset", false);
            builder.pop();
            builder.push("Gui");
            this.enable_silver_hearts = builder.comment("Makes the extra hearts given by life shards display as silver colored").translation("config.aether.client.gui.enable_silver_hearts").define("Enables silver life shard hearts", true);
            this.disable_accessory_button = builder.comment("Disables the Aether's accessories button from appearing in GUIs").translation("config.aether.client.gui.disable_accessory_button").define("Disables the accessories button", false);
            this.disable_skins_button = builder.comment("Disables the Aether's Moa Skins button from appearing in GUIs").translation("config.aether.client.gui.disable_skins_button").define("Disables the Moa Skins button", false);
            this.portal_text_y = builder.comment("The y-coordinate of the Ascending to the Aether and Descending from the Aether text in loading screens").translation("config.aether.client.gui.portal_text_y").define("Portal text y-coordinate in loading screens", (Object)50);
            this.button_inventory_x = builder.comment("The x-coordinate of the accessories button in the inventory and accessories menus").translation("config.aether.client.gui.button_inventory_x").define("Button x-coordinate in inventory menus", (Object)27);
            this.button_inventory_y = builder.comment("The y-coordinate of the accessories button in the inventory and accessories menus").translation("config.aether.client.gui.button_inventory_y").define("Button y-coordinate in inventory menus", (Object)68);
            this.button_creative_x = builder.comment("The x-coordinate of the accessories button in the creative menu").translation("config.aether.client.gui.button_creative_x").define("Button x-coordinate in creative menu", (Object)74);
            this.button_creative_y = builder.comment("The y-coordinate of the accessories button in the creative menu").translation("config.aether.client.gui.button_creative_y").define("Button y-coordinate in creative menu", (Object)40);
            this.button_accessories_x = builder.comment("The x-coordinate of the accessories button in the accessories menu").translation("config.aether.client.gui.button_accessories_x").define("Button x-coordinate in accessories menu", (Object)9);
            this.button_accessories_y = builder.comment("The y-coordinate of the accessories button in the accessories menu").translation("config.aether.client.gui.button_accessories_y").define("Button y-coordinate in accessories menu", (Object)68);
            this.layout_perks_x = builder.comment("The x-coordinate of the layout of perks buttons when in the pause menu").translation("config.aether.client.gui.layout_perks_x").define("Perks layout x-coordinate in pause menu", (Object)-116);
            this.layout_perks_y = builder.comment("The y-coordinate of the layout of perks buttons when in the pause menu").translation("config.aether.client.gui.layout_perks_y").define("Perks layout y-coordinate in pause menu", (Object)0);
            this.enable_hammer_cooldown_overlay = builder.comment("Enables the overlay at the top of the screen for the Hammer of Kingbdogz' cooldown").translation("config.aether.client.gui.enable_hammer_cooldown_overlay").define("Enables Hammer of Kingbdogz' cooldown overlay", true);
            builder.pop();
            builder.push("Audio");
            this.blue_aercloud_bounce_sfx = builder.comment("Makes Blue Aerclouds have their wobbly sounds that play when bouncing on them").translation("config.aether.client.audio.blue_aercloud_bounce_sfx").define("Blue Aercloud bouncing sounds", true);
            this.music_backup_min_delay = builder.comment("Sets the minimum delay for the Aether's music manager to use if needing to reset the song delay outside the Aether").translation("config.aether.client.audio.music_backup_min_delay").define("Set backup minimum music delay", (Object)12000);
            this.music_backup_max_delay = builder.comment("Sets the maximum delay for the Aether's music manager to use if needing to reset the song delay outside the Aether").translation("config.aether.client.audio.music_backup_max_delay").define("Set backup maximum music delay", (Object)24000);
            this.disable_music_manager = builder.comment("Disables the Aether's internal music manager, if true, this overrides all other audio configs").translation("config.aether.client.audio.disable_music_manager").define("Disables Aether music manager", false);
            this.disable_aether_boss_music = builder.comment("Disables the Aether's boss fight music, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_aether_boss_music").define("Disables Aether boss music", false);
            this.disable_aether_menu_music = builder.comment("Disables the Aether's menu music in case another mod implements its own, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_aether_menu_music").define("Disables Aether menu music", false);
            this.disable_vanilla_world_preview_menu_music = builder.comment("Disables the menu music on the vanilla world preview menu, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_vanilla_world_preview_menu_music").define("Disables vanilla world preview menu music", false);
            this.disable_aether_world_preview_menu_music = builder.comment("Disables the menu music on the Aether world preview menu, only works if 'Disables Aether music manager' is false").translation("config.aether.client.audio.disable_aether_world_preview_menu_music").define("Disables Aether world preview menu music", false);
            builder.pop();
            builder.push("Miscellaneous");
            this.enable_server_button = builder.comment("Enables a direct join button for the official server").translation("config.aether.client.miscellaneous.enable_server_button").define("Enables server button", false);
            builder.pop();
        }
    }
}

