/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.natural;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherPlacedFeatures;
import com.aetherteam.aether.mixin.mixins.common.accessor.SpreadingSnowyDirtBlockAccessor;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class EnchantedAetherGrassBlock
extends GrassBlock {
    public EnchantedAetherGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onTreeGrow(BlockState state, LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        placeFunction.accept(pos, ((Block)AetherBlocks.AETHER_DIRT.get()).defaultBlockState());
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!SpreadingSnowyDirtBlockAccessor.callCanBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            level.setBlockAndUpdate(pos, ((Block)AetherBlocks.AETHER_DIRT.get()).defaultBlockState());
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.above();
        Block grass = (Block)AetherBlocks.AETHER_GRASS_BLOCK.get();
        Optional grassFeatureOptional = level.holder(AetherPlacedFeatures.ENCHANTED_AETHER_GRASS_BONEMEAL);
        block0: for (int i = 0; i < 128; ++i) {
            Holder featureHolder;
            BlockPos blockPos = abovePos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((blockPos = blockPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(blockPos).isCollisionShapeFullBlock((BlockGetter)level, blockPos)) continue block0;
            }
            BlockState blockState = level.getBlockState(blockPos);
            if (blockState.is(grass) && random.nextInt(10) == 0) {
                ((BonemealableBlock)grass).performBonemeal(level, random, blockPos, blockState);
            }
            if (!blockState.isAir()) continue;
            if (random.nextInt(8) == 0) {
                List list = ((Biome)level.getBiome(blockPos).value()).getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) continue;
                featureHolder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(random.nextInt(list.size()))).config()).feature();
            } else {
                if (grassFeatureOptional.isEmpty()) continue;
                featureHolder = (Holder)grassFeatureOptional.get();
            }
            ((PlacedFeature)featureHolder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, blockPos);
        }
    }
}

