/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.aether.client.renderer.level.AetherSkyRenderEffects;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class DimensionClientHooks {
    @Nullable
    public static Float renderNearFog(Camera camera, FogRenderer.FogMode mode, float farDistance) {
        ClientLevel clientLevel;
        Level level = camera.getEntity().level();
        if (level instanceof ClientLevel && (clientLevel = (ClientLevel)level).effects() instanceof AetherSkyRenderEffects) {
            FogType fluidState = camera.getFluidInCamera();
            if (mode == FogRenderer.FogMode.FOG_TERRAIN && fluidState == FogType.NONE) {
                return Float.valueOf(farDistance / 2.0f);
            }
        }
        return null;
    }

    @Nullable
    public static Float reduceLavaFog(Camera camera, float nearDistance) {
        FogType fluidState;
        LivingEntity livingEntity;
        Entity entity;
        if (camera.getEntity().level() instanceof ClientLevel && (entity = camera.getEntity()) instanceof LivingEntity && EquipmentUtil.hasFullPhoenixSet(livingEntity = (LivingEntity)entity) && (fluidState = camera.getFluidInCamera()) == FogType.LAVA) {
            return Float.valueOf(nearDistance * 5.0f);
        }
        return null;
    }

    @Nullable
    public static Triple<Float, Float, Float> renderFogColors(Camera camera, float red, float green, float blue) {
        ClientLevel clientLevel;
        Level level = camera.getEntity().level();
        if (level instanceof ClientLevel && (clientLevel = (ClientLevel)level).effects() instanceof AetherSkyRenderEffects) {
            ClientLevel.ClientLevelData worldInfo = clientLevel.getLevelData();
            double d0 = (camera.getPosition().y() - (double)clientLevel.getMinBuildHeight()) * (double)worldInfo.getClearColorScale();
            FogType fluidState = camera.getFluidInCamera();
            if (d0 < 1.0 && fluidState != FogType.LAVA) {
                if (d0 < 0.0) {
                    d0 = 0.0;
                }
                if ((d0 *= d0) != 0.0) {
                    return Triple.of((Object)Float.valueOf((float)((double)red / d0)), (Object)Float.valueOf((float)((double)green / d0)), (Object)Float.valueOf((float)((double)blue / d0)));
                }
            }
        }
        return null;
    }

    @Nullable
    public static Triple<Float, Float, Float> adjustWeatherFogColors(Camera camera, float red, float green, float blue) {
        FogType fluidState;
        ClientLevel clientLevel;
        Level level = camera.getEntity().level();
        if (level instanceof ClientLevel && (clientLevel = (ClientLevel)level).effects() instanceof AetherSkyRenderEffects && (fluidState = camera.getFluidInCamera()) == FogType.NONE) {
            Vec3 defaultSky = Vec3.fromRGB24((int)((Biome)clientLevel.getBiome(camera.getBlockPosition()).value()).getModifiedSpecialEffects().getFogColor());
            if ((double)clientLevel.rainLevel > 0.0) {
                float f14 = 1.0f + clientLevel.rainLevel * 0.8f;
                float f17 = 1.0f + clientLevel.rainLevel * 0.56f;
                red *= f14;
                green *= f14;
                blue *= f17;
            }
            if ((double)clientLevel.thunderLevel > 0.0) {
                float f18 = 1.0f + clientLevel.thunderLevel * 0.66f;
                float f19 = 1.0f + clientLevel.thunderLevel * 0.76f;
                red *= f18;
                green *= f18;
                blue *= f19;
            }
            red = (float)Math.min((double)red, defaultSky.x());
            green = (float)Math.min((double)green, defaultSky.y());
            blue = (float)Math.min((double)blue, defaultSky.z());
            return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
        }
        return null;
    }

    public static void tickTime() {
        LevelAccessor levelAccessor;
        AetherTimeAttachment data;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && !Minecraft.getInstance().isPaused() && level.dimensionType().effectsLocation().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.location()) && !(data = (AetherTimeAttachment)level.getData(AetherDataAttachments.AETHER_TIME)).isTimeSynced() && (levelAccessor = (LevelAccessor)level).aether$getLevelData().getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
            level.setDayTime(data.tickTime((Level)level) - 1L);
        }
    }
}

