/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AetherPortalItem
extends Item {
    public AetherPortalItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.createPortalFrame(context)) {
            player.swing(context.getHand());
            if (!player.getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private boolean createPortalFrame(UseOnContext context) {
        BlockPos truePos;
        int v;
        int h;
        BlockPos pos;
        Level level = context.getLevel();
        if (!level.getBlockState(pos = context.getClickedPos()).canBeReplaced(new BlockPlaceContext(context))) {
            pos = pos.relative(context.getClickedFace());
        }
        Direction.Axis axis = context.getHorizontalDirection().getAxis();
        for (h = -1; h < 3; ++h) {
            for (v = pos.getY(); v < pos.getY() + 5; ++v) {
                BlockPos blockPos = truePos = axis == Direction.Axis.X ? new BlockPos(pos.getX(), v, pos.getZ() + h) : new BlockPos(pos.getX() + h, v, pos.getZ());
                if (level.getBlockState(truePos).canBeReplaced(new BlockPlaceContext(context))) continue;
                return false;
            }
        }
        for (h = -1; h < 3; ++h) {
            for (v = pos.getY(); v < pos.getY() + 5; ++v) {
                truePos = axis == Direction.Axis.X ? new BlockPos(pos.getX(), v, pos.getZ() + h) : new BlockPos(pos.getX() + h, v, pos.getZ());
                level.setBlockAndUpdate(truePos, Blocks.GLOWSTONE.defaultBlockState());
            }
        }
        for (h = 0; h < 2; ++h) {
            for (v = pos.getY() + 1; v < pos.getY() + 4; ++v) {
                truePos = axis == Direction.Axis.X ? new BlockPos(pos.getX(), v, pos.getZ() + h) : new BlockPos(pos.getX() + h, v, pos.getZ());
                Direction.Axis trueAxis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
                level.setBlock(truePos, (BlockState)((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).defaultBlockState().setValue(AetherPortalBlock.AXIS, (Comparable)trueAxis), 18);
            }
        }
        return true;
    }
}

