/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.golddungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class GoldStubCave
extends StructurePiece {
    public GoldStubCave(BoundingBox box) {
        super((StructurePieceType)AetherStructurePieceTypes.GUMDROP_CAVE.get(), 0, box);
    }

    public GoldStubCave(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)AetherStructurePieceTypes.GUMDROP_CAVE.get(), tag);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos startPos) {
        BlockPos center = this.boundingBox.getCenter();
        float f = random.nextFloat() * (float)Math.PI;
        int i = center.getX();
        int j = center.getY();
        int k = center.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double offset = 3.75;
        double lowerX = (double)i + (double)Mth.sin((float)f) * offset;
        double upperX = (double)i - (double)Mth.sin((float)f) * offset;
        double lowerZ = (double)k + (double)Mth.cos((float)f) * offset;
        double upperZ = (double)k - (double)Mth.cos((float)f) * offset;
        double lowerY = j + random.nextInt(3) + 2;
        double upperY = j + random.nextInt(3) + 2;
        for (int length = 0; length <= 30; ++length) {
            double radius = (double)length / 30.0;
            double x = lowerX + (upperX - lowerX) * radius;
            double y = lowerY + (upperY - lowerY) * radius;
            double z = lowerZ + (upperZ - lowerZ) * radius;
            double magnitude = random.nextDouble() * 30.0 / 16.0;
            double width = (Math.sin(radius * 3.1415927410125732) + 1.0) * magnitude + 1.0;
            int minX = Mth.floor((double)(x - (width /= 2.0)));
            int minY = Mth.floor((double)(y - width));
            int minZ = Mth.floor((double)(z - width));
            int maxX = Mth.floor((double)(x + width));
            int maxY = Mth.floor((double)(y + width));
            int maxZ = Mth.floor((double)(z + width));
            for (int xOffset = minX; xOffset <= maxX; ++xOffset) {
                double xDistance = Mth.square((double)(((double)xOffset + 0.5 - x) / width));
                if (!(xDistance < 1.0)) continue;
                for (int yOffset = minY; yOffset <= maxY; ++yOffset) {
                    double yDistance = Mth.square((double)(((double)yOffset + 0.5 - y) / width));
                    if (!(xDistance + yDistance < 1.0)) continue;
                    for (int zOffset = minZ; zOffset <= maxZ; ++zOffset) {
                        BlockState state;
                        double zDistance = Mth.square((double)(((double)zOffset + 0.5 - z) / width));
                        if (!(xDistance + yDistance + zDistance < 1.0) || !(state = level.getBlockState((BlockPos)mutable.set(xOffset, yOffset, zOffset))).is(AetherTags.Blocks.AETHER_DIRT) && !state.is(AetherTags.Blocks.HOLYSTONE)) continue;
                        level.setBlock((BlockPos)mutable, Blocks.AIR.defaultBlockState(), 2);
                    }
                }
            }
        }
    }
}

