/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.silverdungeon;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.blockentity.TreasureChestBlockEntity;
import com.aetherteam.aether.loot.AetherLoot;
import com.aetherteam.aether.world.processor.BorderBoxPosTest;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonPiece;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SilverBossRoom
extends SilverDungeonPiece {
    public SilverBossRoom(StructureTemplateManager manager, String name, BlockPos pos, Rotation rotation, Holder<StructureProcessorList> processors) {
        super((StructurePieceType)AetherStructurePieceTypes.SILVER_BOSS_ROOM.get(), manager, name, SilverBossRoom.makeSettings(manager, SilverDungeonPiece.makeLocation(name)).setRotation(rotation), pos, processors);
        this.setOrientation(rotation.rotate(Direction.SOUTH));
    }

    public SilverBossRoom(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)AetherStructurePieceTypes.SILVER_BOSS_ROOM.get(), context.registryAccess(), tag, context.structureTemplateManager(), (ResourceLocation resourceLocation) -> SilverBossRoom.makeSettings(context.structureTemplateManager(), ResourceLocation.parse((String)tag.getString("Template"))));
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager templateManager, ResourceLocation name) {
        return new StructurePlaceSettings().addProcessor(SilverBossRoom.makeBoxProcessor(templateManager, name)).setFinalizeEntities(true);
    }

    private static StructureProcessor makeBoxProcessor(StructureTemplateManager templateManager, ResourceLocation id) {
        Vec3i template = templateManager.getOrCreate(id).getSize();
        BorderBoxPosTest borderTest = new BorderBoxPosTest(0, 1, 0, template.getX() - 1, template.getY() - 1, template.getZ() - 1);
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AetherBlocks.LOCKED_ANGELIC_STONE.get(), 0.05f), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)borderTest, ((Block)AetherBlocks.LOCKED_LIGHT_ANGELIC_STONE.get()).defaultBlockState())));
    }

    @Override
    protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        if (name.equals("Treasure Chest")) {
            BlockPos chest = pos.below();
            BlockEntity entity = level.getBlockEntity(chest);
            if (entity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)entity;
                container.setLootTable(AetherLoot.SILVER_DUNGEON_REWARD, random.nextLong());
            }
            TreasureChestBlockEntity.setDungeonType((BlockGetter)level, chest, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"silver"));
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
    }
}

