/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.effect;

import io.redspace.ironsspellbooks.effect.ISyncedMobEffect;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class TrueInvisibilityEffect
extends MagicMobEffect
implements ISyncedMobEffect {
    int lastHurtTimestamp;

    public TrueInvisibilityEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    @Override
    public void onEffectAdded(LivingEntity livingEntity, int pAmplifier) {
        super.onEffectAdded(livingEntity, pAmplifier);
        TargetingConditions targetingCondition = TargetingConditions.forCombat().ignoreLineOfSight().selector(e -> ((Mob)e).getTarget() == livingEntity);
        livingEntity.level.getNearbyEntities(Mob.class, targetingCondition, livingEntity, livingEntity.getBoundingBox().inflate(40.0)).forEach(entityTargetingCaster -> {
            entityTargetingCaster.setTarget(null);
            entityTargetingCaster.targetSelector.getAvailableGoals().forEach(WrappedGoal::stop);
            entityTargetingCaster.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        });
        this.lastHurtTimestamp = livingEntity.getLastHurtMobTimestamp();
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }

    @Override
    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        return pLivingEntity.level.isClientSide || this.lastHurtTimestamp == pLivingEntity.getLastHurtMobTimestamp();
    }
}

