/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.override;

import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.override.XyOverride;

@EventBusSubscriber(modid="xycraft_override", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class XyOverrideClient {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAddPackFinders(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                XyOverrideClient.addPack(event, "OverridesStone", "add_xycraft_overrides_stone", "XyCraft Stone Overrides", true);
                XyOverrideClient.addPack(event, "OverridesMetal", "add_xycraft_overrides_metal", "XyCraft Metal Overrides", true);
                XyOverrideClient.addPack(event, "OverridesGlass", "add_xycraft_overrides_glass", "XyCraft Glass Overrides", true);
                XyOverrideClient.addPack(event, "OverridesOptionalMC", "add_xycraft_overrides_optional_mc", "XyCraft Model Overrides", false);
                if (CompatContent.AE2.Mod.isLoaded()) {
                    XyOverrideClient.addPack(event, "OverridesAE2", "add_xycraft_override_ae2", "XyCraft AE2 Overrides", false);
                }
            }
        }
        catch (Exception ex) {
            XyOverride.Logger.error("Resource Pack threw an error! Please report this to the XyCraft issue tracker: https://github.com/Soaryn/XyCraftTracker/issues");
            XyOverride.Logger.error(ex.toString());
        }
    }

    private static void addPack(AddPackFindersEvent event, String pathName, String keyName, String packName, boolean required) {
        Path resourcePath = ModList.get().getModFileById("xycraft_override").getFile().findResource(new String[]{pathName});
        Pack p = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(keyName, (Component)Component.translatable((String)packName), PackSource.BUILT_IN, Optional.of(BuiltInPackSource.CORE_PACK_INFO)), (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(resourcePath), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(required, Pack.Position.TOP, false));
        event.addRepositorySource(packConsumer -> packConsumer.accept(p));
    }

    @SubscribeEvent
    public static void onRegisterColorHandler(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, index) -> index != 1 ? -1 : ((Boolean)state.getValue((Property)ObserverBlock.POWERED) != false ? -65536 : -10485760), new Block[]{Blocks.OBSERVER});
    }

    @SubscribeEvent
    public static void onRegisterColorHandler(RegisterColorHandlersEvent.Item event) {
        event.register((state, index) -> index != 1 ? -1 : -10485760, new ItemLike[]{Blocks.OBSERVER});
    }
}

