/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.common.capabilities;

import dev.satherov.utilityvest.common.item.UVVestItem;
import dev.satherov.utilityvest.core.UVRegistry;
import dev.satherov.utilityvest.core.annotations.NothingNull;
import dev.satherov.utilityvest.core.lang.UVLanguage;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

@NothingNull
public class UVVestCapability
implements IItemHandlerModifiable {
    public final ComponentItemHandler filters;
    public final ComponentItemHandler storage;

    public UVVestCapability(ItemStack stack, UVVestItem vest) {
        ItemStack item;
        int i;
        int maxBanks = vest.getMaxBanks();
        this.filters = new ComponentItemHandler((MutableDataComponentHolder)stack, (DataComponentType)UVRegistry.FILTER_INVENTORY.get(), maxBanks * 9);
        this.storage = new ComponentItemHandler((MutableDataComponentHolder)stack, (DataComponentType)UVRegistry.ITEM_INVENTORY.get(), maxBanks * 9);
        ComponentItemHandler old = new ComponentItemHandler((MutableDataComponentHolder)stack, (DataComponentType)UVRegistry.VEST_INVENTORY.get(), maxBanks * 18);
        int split = old.getSlots() / 2;
        for (i = 0; i < split; ++i) {
            item = old.extractItem(i, old.getStackInSlot(i).getCount(), false);
            if (item.isEmpty()) continue;
            this.filters.insertItem(i, item, false);
        }
        for (i = split; i < old.getSlots(); ++i) {
            item = old.extractItem(i, old.getStackInSlot(i).getCount(), false);
            if (item.isEmpty()) continue;
            this.storage.insertItem(i - split, item, false);
        }
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.storage.setStackInSlot(slot, stack);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }

    public void saveHotbar(Player player, int index) {
        NonNullList<ItemStack> hotbar = this.getHotbar(player.getInventory());
        for (int i = 0; i < 9; ++i) {
            this.filters.setStackInSlot(i + index * 9, ((ItemStack)hotbar.get(i)).copy());
        }
        player.inventoryMenu.broadcastChanges();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.containerMenu.broadcastChanges();
        }
        player.displayClientMessage((Component)UVLanguage.CHAT_SAVED.translate(index).withStyle(ChatFormatting.GRAY), true);
    }

    public void loadHotbar(Player player, int index) {
        NonNullList<ItemStack> hotbar = this.getHotbar(player.getInventory());
        ArrayList<ItemStack> itemsToReturn = new ArrayList<ItemStack>();
        for (Object stack : hotbar) {
            if (this.matchFilter((ItemStack)stack)) {
                ItemStack overflow = this.insertWithOverflow((ItemStack)stack);
                if (overflow.isEmpty()) continue;
                itemsToReturn.add(overflow);
                continue;
            }
            itemsToReturn.add((ItemStack)stack);
        }
        for (int i = 0; i < 9; ++i) {
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        int slot = 0;
        for (ItemStack stack : this.getFilters(index)) {
            if (!stack.isEmpty()) {
                player.getInventory().setItem(slot, this.buildStackFromItems(stack, new ContainerItemHandler(this)));
            }
            ++slot;
        }
        for (ItemStack stack : itemsToReturn) {
            ItemStack remaining = stack.copy();
            Inventory inv = player.getInventory();
            int match = inv.findSlotMatchingItem(stack);
            if (match != -1) {
                ItemStack inSlot = inv.getItem(match);
                int toInsert = Math.min(stack.getCount(), inSlot.getMaxStackSize() - inSlot.getCount());
                int remainingCount = stack.getCount() - toInsert;
                ItemStack matchCopy = stack.copyWithCount(toInsert);
                if (toInsert > 0) {
                    inv.add(match, matchCopy);
                }
                if (remainingCount > 0) {
                    remaining = stack.copyWithCount(remainingCount);
                }
            }
            for (int i = 9; i < inv.items.size(); ++i) {
                if (!((ItemStack)inv.items.get(i)).isEmpty()) continue;
                inv.add(i, remaining);
                remaining = ItemStack.EMPTY;
                break;
            }
            if (!remaining.isEmpty()) {
                remaining = this.insertWithOverflow(remaining);
            }
            if (remaining.isEmpty()) continue;
            player.drop(remaining, false);
        }
        player.inventoryMenu.broadcastChanges();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.containerMenu.broadcastChanges();
        }
        player.displayClientMessage((Component)UVLanguage.CHAT_LOADED.translate(index).withStyle(ChatFormatting.GRAY), true);
    }

    public void collectItems(Player player) {
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !this.matchFilter(stack)) continue;
            inv.setItem(i, this.insertWithOverflow(stack));
        }
        player.displayClientMessage((Component)UVLanguage.CHAT_RESTOCKED.translate().withStyle(ChatFormatting.GRAY), true);
    }

    private NonNullList<ItemStack> getHotbar(Inventory inv) {
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])((ItemStack[])inv.items.stream().limit(9L).toArray(ItemStack[]::new)));
    }

    public NonNullList<ItemStack> getFilters() {
        NonNullList contents = NonNullList.withSize((int)this.filters.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            contents.set(i, (Object)this.filters.getStackInSlot(i));
        }
        if (contents.isEmpty()) {
            return NonNullList.withSize((int)this.filters.getSlots(), (Object)ItemStack.EMPTY);
        }
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])((ItemStack[])contents.toArray(ItemStack[]::new)));
    }

    public NonNullList<ItemStack> getFilters(int index) {
        NonNullList results = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        int startIndex = index * 9;
        for (int i = 0; i < 9; ++i) {
            if (startIndex + i >= this.filters.getSlots()) continue;
            results.set(i, (Object)this.filters.getStackInSlot(startIndex + i));
        }
        return results;
    }

    public boolean matchFilter(ItemStack stack) {
        NonNullList<ItemStack> filtersList = this.getFilters();
        if (filtersList.stream().allMatch(ItemStack::isEmpty)) {
            return true;
        }
        return filtersList.stream().anyMatch(f -> ItemStack.isSameItem((ItemStack)f, (ItemStack)stack));
    }

    private ItemStack insertWithOverflow(ItemStack toInsert) {
        int i;
        if (toInsert.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = toInsert.copy();
        for (i = 0; i < this.getSlots(); ++i) {
            ItemStack inSlot = this.getStackInSlot(i);
            if (inSlot.isEmpty() || !ItemStack.isSameItem((ItemStack)inSlot, (ItemStack)remainder) || !(remainder = this.insertItem(i, remainder, false)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (i = 0; i < this.getSlots() && !remainder.isEmpty(); ++i) {
            if (!this.getStackInSlot(i).isEmpty()) continue;
            remainder = this.insertItem(i, remainder, false);
        }
        return remainder;
    }

    private ItemStack buildStackFromItems(ItemStack template, IItemSourceHandler source) {
        if (template.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        int neededAmount = template.getCount();
        for (int i = 0; i < source.getSize(); ++i) {
            ItemStack storedItem = source.getStackInSlot(i);
            if (storedItem.isEmpty() || !ItemStack.isSameItem((ItemStack)template, (ItemStack)storedItem)) continue;
            if (result.isEmpty()) {
                result = storedItem.copy();
                int extracted = source.extractItem(i, Math.min(storedItem.getCount(), neededAmount));
                result.setCount(extracted);
            } else {
                int remainingNeeded = neededAmount - result.getCount();
                int extracted = source.extractItem(i, Math.min(storedItem.getCount(), remainingNeeded));
                result.grow(extracted);
            }
            if (result.getCount() != neededAmount) continue;
            return result;
        }
        return result;
    }

    private record ContainerItemHandler(UVVestCapability container) implements IItemSourceHandler
    {
        @Override
        public int getSize() {
            return this.container.getSlots();
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return this.container.getStackInSlot(slot);
        }

        @Override
        public int extractItem(int slot, int amount) {
            return this.container.extractItem(slot, amount, false).getCount();
        }
    }

    private static interface IItemSourceHandler {
        public int getSize();

        public ItemStack getStackInSlot(int var1);

        public int extractItem(int var1, int var2);
    }

    private record PlayerInventoryHandler(Inventory inventory) implements IItemSourceHandler
    {
        @Override
        public int getSize() {
            return this.inventory.getContainerSize();
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return this.inventory.getItem(slot);
        }

        @Override
        public int extractItem(int slot, int amount) {
            return this.inventory.removeItem(slot, amount).getCount();
        }
    }
}

