/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.events.Events;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.StringUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.network.APNetworking;
import de.srendi.advancedperipherals.network.toclient.ToastToClientPacket;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ChatBoxPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "chat_box";
    private long lastConsumedMessage;

    protected ChatBoxPeripheral(IPeripheralOwner owner) {
        super(PERIPHERAL_TYPE, owner);
        owner.attachOperation(SimpleFreeOperation.CHAT_MESSAGE);
        this.lastConsumedMessage = Events.getLastChatMessageID() - 1L;
    }

    public ChatBoxPeripheral(PeripheralBlockEntity<?> tileEntity) {
        this(new BlockEntityPeripheralOwner(tileEntity));
    }

    public ChatBoxPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side));
    }

    public ChatBoxPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableChatBox.get();
    }

    protected MethodResult withChatOperation(IPeripheralFunction<Object, MethodResult> function) throws LuaException {
        return this.withOperation(SimpleFreeOperation.CHAT_MESSAGE, null, null, function, null);
    }

    private MutableComponent appendPrefix(String prefix, String brackets, String color) {
        MutableComponent prefixComponent = Component.literal((String)((String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get()));
        if (!prefix.isEmpty()) {
            try {
                MutableComponent formattablePrefix;
                prefixComponent = formattablePrefix = Component.Serializer.fromJson((String)prefix, (HolderLookup.Provider)RegistryAccess.EMPTY);
            }
            catch (JsonSyntaxException exception) {
                AdvancedPeripherals.debug("Non json prefix, using plain text instead.");
                prefixComponent = Component.literal((String)prefix);
            }
        }
        if (brackets.isEmpty()) {
            brackets = "[]";
        }
        return Component.literal((String)(color + brackets.charAt(0) + "\u00a7r")).append((Component)prefixComponent).append(color + brackets.charAt(1) + "\u00a7r ");
    }

    private ServerPlayer getPlayer(String argument) {
        if (argument.matches("\\b[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\b")) {
            return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(UUID.fromString(argument));
        }
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(argument);
    }

    private boolean checkBrackets(Optional<String> brackets) {
        return brackets.isPresent() && brackets.get().length() != 2;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessage(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            boolean useUTF8 = arguments.optBoolean(5, false);
            String message = arguments.getString(0);
            if (message.length() > (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMessageSize.get()) {
                return MethodResult.of((Object[])new Object[]{null, "Message is too long"});
            }
            if (useUTF8) {
                message = StringUtil.byteStringToUTF8(message);
            }
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(4, -1);
            ResourceKey dimension = this.getLevel().dimension();
            MutableComponent component = Component.Serializer.fromJson((String)message, (HolderLookup.Provider)RegistryAccess.EMPTY);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            Optional<String> brackets = arguments.optString(2);
            if (useUTF8) {
                brackets = brackets.map(StringUtil::byteStringToUTF8);
            }
            if (this.checkBrackets(brackets)) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            Optional<String> prefix = arguments.optString(1);
            if (useUTF8) {
                prefix = prefix.map(StringUtil::byteStringToUTF8);
            }
            String bracketColor = arguments.optString(3, "");
            if (useUTF8) {
                bracketColor = StringUtil.byteStringToUTF8(bracketColor);
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(prefix.orElseGet((Supplier<String>)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix)), brackets.orElse("[]"), StringUtil.convertAndToSectionMark(bracketColor)).append((Component)component);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.level().dimension() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) continue;
                player.sendSystemMessage((Component)preparedMessage);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessage(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            boolean useUTF8 = arguments.optBoolean(5, false);
            String message = arguments.getString(0);
            if (message.length() > (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMessageSize.get()) {
                return MethodResult.of((Object[])new Object[]{null, "Message is too long"});
            }
            if (useUTF8) {
                message = StringUtil.byteStringToUTF8(message);
            }
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(4, -1);
            ResourceKey dimension = this.getLevel().dimension();
            Optional<String> brackets = arguments.optString(2);
            if (useUTF8) {
                brackets = brackets.map(StringUtil::byteStringToUTF8);
            }
            if (this.checkBrackets(brackets)) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            Optional<String> prefix = arguments.optString(1);
            if (useUTF8) {
                prefix = prefix.map(StringUtil::byteStringToUTF8);
            }
            String bracketColor = arguments.optString(3, "");
            if (useUTF8) {
                bracketColor = StringUtil.byteStringToUTF8(bracketColor);
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(prefix.orElseGet((Supplier<String>)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix)), brackets.orElse("[]"), StringUtil.convertAndToSectionMark(bracketColor)).append(message);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.level().dimension() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) continue;
                player.sendSystemMessage((Component)preparedMessage);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessageToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            boolean useUTF8 = arguments.optBoolean(5, false);
            String message = arguments.getString(0);
            if (message.length() > (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMessageSize.get()) {
                return MethodResult.of((Object[])new Object[]{null, "Message is too long"});
            }
            if (useUTF8) {
                message = StringUtil.byteStringToUTF8(message);
            }
            String playerName = arguments.getString(1);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(5, -1);
            ResourceKey dimension = this.getLevel().dimension();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            MutableComponent component = Component.Serializer.fromJson((String)message, (HolderLookup.Provider)RegistryAccess.EMPTY);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            Optional<String> brackets = arguments.optString(3);
            if (useUTF8) {
                brackets = brackets.map(StringUtil::byteStringToUTF8);
            }
            if (this.checkBrackets(brackets)) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            Optional<String> prefix = arguments.optString(2);
            if (useUTF8) {
                prefix = prefix.map(StringUtil::byteStringToUTF8);
            }
            String bracketColor = arguments.optString(4, "");
            if (useUTF8) {
                bracketColor = StringUtil.byteStringToUTF8(bracketColor);
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(prefix.orElseGet((Supplier<String>)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix)), brackets.orElse("[]"), StringUtil.convertAndToSectionMark(bracketColor)).append((Component)component);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.level().dimension() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                player.sendSystemMessage((Component)preparedMessage);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedToastToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            boolean useUTF8 = arguments.optBoolean(7, false);
            String message = arguments.getString(0);
            if (message.length() > (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMessageSize.get()) {
                return MethodResult.of((Object[])new Object[]{null, "Message is too long"});
            }
            if (useUTF8) {
                message = StringUtil.byteStringToUTF8(message);
            }
            String title = arguments.getString(1);
            if (useUTF8) {
                title = StringUtil.byteStringToUTF8(title);
            }
            String playerName = arguments.getString(2);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(6, -1);
            ResourceKey dimension = this.getLevel().dimension();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            MutableComponent messageComponent = Component.Serializer.fromJson((String)message, (HolderLookup.Provider)RegistryAccess.EMPTY);
            if (messageComponent == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json for message"});
            }
            MutableComponent titleComponent = Component.Serializer.fromJson((String)title, (HolderLookup.Provider)RegistryAccess.EMPTY);
            if (titleComponent == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json for title"});
            }
            Optional<String> brackets = arguments.optString(4);
            if (useUTF8) {
                brackets = brackets.map(StringUtil::byteStringToUTF8);
            }
            if (this.checkBrackets(brackets)) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ,,,)"});
            }
            Optional<String> prefix = arguments.optString(3);
            if (useUTF8) {
                prefix = prefix.map(StringUtil::byteStringToUTF8);
            }
            String bracketColor = arguments.optString(5, "");
            if (useUTF8) {
                bracketColor = StringUtil.byteStringToUTF8(bracketColor);
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(prefix.orElseGet((Supplier<String>)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix)), brackets.orElse("[]"), StringUtil.convertAndToSectionMark(bracketColor)).append((Component)messageComponent);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.level().dimension() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                ToastToClientPacket packet = new ToastToClientPacket((Component)titleComponent, (Component)preparedMessage);
                APNetworking.sendTo(player, packet);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessageToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            boolean useUTF8 = arguments.optBoolean(6, false);
            String message = arguments.getString(0);
            if (message.length() > (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMessageSize.get()) {
                return MethodResult.of((Object[])new Object[]{null, "Message is too long"});
            }
            if (useUTF8) {
                message = StringUtil.byteStringToUTF8(message);
            }
            String playerName = arguments.getString(1);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(5, -1);
            ResourceKey dimension = this.getLevel().dimension();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            Optional<String> brackets = arguments.optString(3);
            if (useUTF8) {
                brackets = brackets.map(StringUtil::byteStringToUTF8);
            }
            if (this.checkBrackets(brackets)) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            Optional<String> prefix = arguments.optString(2);
            if (useUTF8) {
                prefix = prefix.map(StringUtil::byteStringToUTF8);
            }
            String bracketColor = arguments.optString(4, "");
            if (useUTF8) {
                bracketColor = StringUtil.byteStringToUTF8(bracketColor);
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(prefix.orElseGet((Supplier<String>)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix)), brackets.orElse("[]"), StringUtil.convertAndToSectionMark(bracketColor)).append(message);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.level().dimension() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                player.sendSystemMessage((Component)preparedMessage, false);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendToastToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            boolean useUTF8 = arguments.optBoolean(7, false);
            String message = arguments.getString(0);
            if (message.length() > (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMessageSize.get()) {
                return MethodResult.of((Object[])new Object[]{null, "Message is too long"});
            }
            if (useUTF8) {
                message = StringUtil.byteStringToUTF8(message);
            }
            String title = arguments.getString(1);
            if (useUTF8) {
                title = StringUtil.byteStringToUTF8(title);
            }
            String playerName = arguments.getString(2);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(6, -1);
            ResourceKey dimension = this.getLevel().dimension();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            Optional<String> brackets = arguments.optString(4);
            if (useUTF8) {
                brackets = brackets.map(StringUtil::byteStringToUTF8);
            }
            if (this.checkBrackets(brackets)) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            Optional<String> prefix = arguments.optString(3);
            if (useUTF8) {
                prefix = prefix.map(StringUtil::byteStringToUTF8);
            }
            String bracketColor = arguments.optString(5, "");
            if (useUTF8) {
                bracketColor = StringUtil.byteStringToUTF8(bracketColor);
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(prefix.orElseGet((Supplier<String>)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix)), brackets.orElse("[]"), StringUtil.convertAndToSectionMark(bracketColor)).append(message);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.level().dimension() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                ToastToClientPacket packet = new ToastToClientPacket((Component)Component.literal((String)title), (Component)preparedMessage);
                APNetworking.sendTo(player, packet);
            }
            return MethodResult.of((Object)true);
        });
    }

    public void update() {
        this.lastConsumedMessage = Events.traverseChatMessages(this.lastConsumedMessage, message -> {
            String byteString = StringUtil.utf8ToByteString(message.message());
            for (IComputerAccess computer : this.getConnectedComputers()) {
                computer.queueEvent("chat", new Object[]{message.username(), message.message(), message.uuid(), message.isHidden(), byteString});
            }
        });
    }
}

