/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import de.srendi.advancedperipherals.common.blocks.base.IHarvestableBlock;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockTagsProvider
extends TagsProvider<Block> {
    @NotNull
    private final DeferredRegister<Block> blockRegistry;
    @NotNull
    private final PackOutput packOutput;

    protected BlockTagsProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> future, @Nullable ExistingFileHelper existingFileHelper, DeferredRegister<Block> registry) {
        super(packOutput, Registries.BLOCK, future, "advancedperipherals", existingFileHelper);
        this.packOutput = packOutput;
        this.blockRegistry = registry;
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        this.blockRegistry.getEntries().stream().map(DeferredHolder::get).forEach(block -> {
            if (!(block instanceof IHarvestableBlock)) {
                throw new IllegalArgumentException("For any block you should define harvester logic!");
            }
            IHarvestableBlock harvesterBlock = (IHarvestableBlock)block;
            this.tag(harvesterBlock.getHarvestTag()).add((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(block).get());
            this.tag(harvesterBlock.getToolTag()).add((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(block).get());
        });
    }

    protected Path getPath(ResourceLocation block) {
        return this.packOutput.getOutputFolder().resolve("data/" + block.getNamespace() + "/tags/blocks/" + block.getPath() + ".json");
    }

    @NotNull
    public String getName() {
        return "Block tags";
    }
}

