/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import de.srendi.advancedperipherals.common.data.BlockLootTablesProvider;
import de.srendi.advancedperipherals.common.data.BlockStatesAndModelsProvider;
import de.srendi.advancedperipherals.common.data.BlockTagsProvider;
import de.srendi.advancedperipherals.common.data.EnUsLanguageProvider;
import de.srendi.advancedperipherals.common.data.PocketUpgradesProvider;
import de.srendi.advancedperipherals.common.data.PoiTypeProvider;
import de.srendi.advancedperipherals.common.data.RecipesProvider;
import de.srendi.advancedperipherals.common.data.TurtleUpgradesProvider;
import de.srendi.advancedperipherals.common.setup.Registration;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="advancedperipherals")
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void genData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        CompletableFuture<HolderLookup.Provider> completablefuture = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagsProvider(packOutput, completablefuture, existingFileHelper, (DeferredRegister<Block>)Registration.BLOCKS));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockLootTablesProvider(packOutput, lookupProvider));
        CompletableFuture fullRegistryPatch = RegistryPatchGenerator.createLookup((CompletableFuture)event.getLookupProvider(), (RegistrySetBuilder)((RegistrySetBuilder)Util.make((Object)new RegistrySetBuilder(), builder -> {
            builder.add(ITurtleUpgrade.REGISTRY, TurtleUpgradesProvider::addUpgrades);
            builder.add(IPocketUpgrade.REGISTRY, PocketUpgradesProvider::addUpgrades);
        })));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, fullRegistryPatch, null));
        generator.addProvider(event.includeServer(), (DataProvider)new PoiTypeProvider(packOutput, completablefuture, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockStatesAndModelsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EnUsLanguageProvider(packOutput));
    }
}

