/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items;

import de.srendi.advancedperipherals.client.ClientUUIDCache;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.items.base.BaseItem;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.common.util.EnumColor;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MemoryCardItem
extends BaseItem {
    public MemoryCardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableInventoryManager.get();
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft minecraft = Minecraft.getInstance();
        if (stack.has(DataComponents.OWNER)) {
            String username = ClientUUIDCache.getUsername((UUID)stack.get(DataComponents.OWNER), minecraft.player.getUUID());
            if (username == null) {
                username = ((UUID)stack.get(DataComponents.OWNER)).toString();
            }
            tooltip.add(EnumColor.buildTextComponent((Component)Component.translatable((String)"item.advancedperipherals.tooltip.memory_card.bound", (Object[])new Object[]{username})));
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        if (!worldIn.isClientSide) {
            ItemStack stack = playerIn.getItemInHand(handIn);
            if (stack.has(DataComponents.OWNER)) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"text.advancedperipherals.removed_player"), true);
                stack.remove(DataComponents.OWNER);
            } else {
                playerIn.displayClientMessage((Component)Component.translatable((String)"text.advancedperipherals.added_player"), true);
                stack.set(DataComponents.OWNER, (Object)playerIn.getUUID());
            }
        }
        return super.use(worldIn, playerIn, handIn);
    }
}

