/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="advancedperipherals")
public class ServerWorker {
    private static final Queue<Runnable> callQueue = new ConcurrentLinkedQueue<Runnable>();

    public static void add(Runnable call) {
        if (call != null) {
            callQueue.add(call);
        }
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        Runnable runnable;
        while ((runnable = callQueue.poll()) != null) {
            AdvancedPeripherals.debug("Running queued server worker call: " + String.valueOf(runnable));
            runnable.run();
        }
        return;
    }
}

