/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block.entity;

import cy.jdkdigital.everythingcopper.common.block.WeatheringStation;
import cy.jdkdigital.everythingcopper.common.container.ManualItemHandler;
import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class WeatheringStationBlockEntity
extends BlockEntity
implements Nameable {
    public static int SLOT_INPUT = 0;
    public static int SLOT_FUEL = 1;
    public static int SLOT_OUTPUT = 2;
    private int tickCounter = 0;
    public boolean isRunning = false;
    public int fluidId = 0;
    public int progress = 0;
    public IItemHandlerModifiable inventoryHandler = new ManualItemHandler(3){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            BlockItem blockItem;
            Item item;
            if (slot == SLOT_FUEL) {
                if (stack.is(Items.WATER_BUCKET)) {
                    return true;
                }
                Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
                if (fluid.isPresent()) {
                    return ((FluidStack)fluid.get()).getFluid().isSame((Fluid)Fluids.WATER);
                }
            }
            return slot == SLOT_INPUT && (stack.getItem() instanceof ICopperItem && ICopperItem.canAge(stack) || (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof WeatheringCopper);
        }

        protected void onContentsChanged(int slot) {
            WeatheringStationBlockEntity.this.setChanged();
            if (slot == SLOT_INPUT && this.getStackInSlot(slot).isEmpty()) {
                WeatheringStationBlockEntity.this.isRunning = false;
                WeatheringStationBlockEntity.this.progress = 0;
            }
        }
    };
    public final IFluidHandler fluidInventory = new FluidTank(10000){

        public boolean isFluidValid(FluidStack stack) {
            return super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            WeatheringStationBlockEntity.this.fluidId = BuiltInRegistries.FLUID.getId((Object)this.getFluid().getFluid());
            if (WeatheringStationBlockEntity.this.level instanceof ServerLevel) {
                if (this.getFluidAmount() >= 100 && !((Boolean)WeatheringStationBlockEntity.this.getBlockState().getValue((Property)WeatheringStation.WET)).booleanValue()) {
                    WeatheringStationBlockEntity.this.level.setBlockAndUpdate(WeatheringStationBlockEntity.this.getBlockPos(), (BlockState)WeatheringStationBlockEntity.this.getBlockState().setValue((Property)WeatheringStation.WET, (Comparable)Boolean.valueOf(true)));
                } else if (this.getFluidAmount() < 100 && ((Boolean)WeatheringStationBlockEntity.this.getBlockState().getValue((Property)WeatheringStation.WET)).booleanValue()) {
                    WeatheringStationBlockEntity.this.level.setBlockAndUpdate(WeatheringStationBlockEntity.this.getBlockPos(), (BlockState)WeatheringStationBlockEntity.this.getBlockState().setValue((Property)WeatheringStation.WET, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    };

    public WeatheringStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WEATHERING_STATION.get(), blockPos, blockState);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, WeatheringStationBlockEntity blockEntity) {
        ItemStack inputItem;
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter % 5 == 0) {
            int availableFluidSpace = blockEntity.fluidInventory.getTankCapacity(0) - blockEntity.fluidInventory.getFluidInTank(0).getAmount();
            ItemStack fuelStack = blockEntity.inventoryHandler.getStackInSlot(SLOT_FUEL);
            if (!fuelStack.isEmpty()) {
                if (fuelStack.is(Items.WATER_BUCKET) && availableFluidSpace >= 1000) {
                    blockEntity.inventoryHandler.setStackInSlot(SLOT_FUEL, fuelStack.getCraftingRemainingItem());
                    blockEntity.fluidInventory.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    Optional fuelContainer = FluidUtil.getFluidHandler((ItemStack)fuelStack);
                    fuelContainer.ifPresent(iFluidHandlerItem -> {
                        Optional<FluidStack> fuel = fuelContainer.map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
                        if (fuel.isPresent() && fuel.get().getAmount() > 0 && fuel.get().getFluid().isSame((Fluid)Fluids.WATER)) {
                            int transferAmount = Math.min(fuel.get().getAmount(), availableFluidSpace);
                            FluidUtil.tryFluidTransfer((IFluidHandler)blockEntity.fluidInventory, (IFluidHandler)iFluidHandlerItem, (int)transferAmount, (boolean)true);
                        }
                    });
                }
            }
        }
        if (blockEntity.isRunning) {
            ++blockEntity.progress;
        }
        if (blockEntity.isRunning && blockEntity.progress >= 200) {
            BlockItem blockItem;
            AtomicBoolean hasFinished = new AtomicBoolean(false);
            ItemStack inputItem2 = blockEntity.inventoryHandler.getStackInSlot(SLOT_INPUT);
            ItemStack outputItem = blockEntity.inventoryHandler.getStackInSlot(SLOT_OUTPUT);
            Item item = inputItem2.getItem();
            if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof WeatheringCopper) {
                WeatheringCopper weatheringBlock = (WeatheringCopper)item;
                weatheringBlock.getNext(blockItem.getBlock().defaultBlockState()).ifPresent(newState -> {
                    ItemStack newItem = new ItemStack((ItemLike)newState.getBlock().asItem());
                    if (outputItem.isEmpty()) {
                        blockEntity.inventoryHandler.setStackInSlot(SLOT_OUTPUT, newItem);
                        hasFinished.set(true);
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)newItem, (ItemStack)outputItem) && outputItem.getCount() < outputItem.getMaxStackSize()) {
                        outputItem.grow(1);
                        hasFinished.set(true);
                    }
                });
            } else if (outputItem.isEmpty() && inputItem2.getItem() instanceof ICopperItem && ICopperItem.canAge(inputItem2)) {
                ItemStack newItem = inputItem2.copy();
                ICopperItem.setAge(newItem, WeatheringUtils.nextState(ICopperItem.getAge(newItem)));
                blockEntity.inventoryHandler.setStackInSlot(SLOT_OUTPUT, newItem);
                hasFinished.set(true);
            }
            if (hasFinished.get()) {
                inputItem2.shrink(1);
                blockEntity.isRunning = false;
                blockEntity.progress = 0;
            }
        }
        if (!blockEntity.isRunning && !(inputItem = blockEntity.inventoryHandler.getStackInSlot(SLOT_INPUT)).isEmpty() && blockEntity.fluidInventory.getFluidInTank(0).getAmount() >= 100) {
            blockEntity.fluidInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
            blockEntity.isRunning = true;
            blockEntity.progress = 0;
        }
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @NotNull
    public Component getName() {
        return Component.translatable((String)"block.everythingcopper.weathering_station");
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.loadPacketNBT(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        this.savePacketNBT(pTag, pRegistries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithId(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadPacketNBT(pkt.getTag(), lookupProvider);
        if (this.level instanceof ClientLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        CompoundTag compound = ((ItemStackHandler)this.inventoryHandler).serializeNBT(pRegistries);
        tag.put("inv", (Tag)compound);
        CompoundTag nbt = new CompoundTag();
        ((FluidTank)this.fluidInventory).writeToNBT(pRegistries, nbt);
        tag.put("fluid", (Tag)nbt);
        tag.putInt("progress", this.progress);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("inv")) {
            ((ItemStackHandler)this.inventoryHandler).deserializeNBT(pRegistries, tag.getCompound("inv"));
        }
        if (tag.contains("fluid")) {
            ((FluidTank)this.fluidInventory).readFromNBT(pRegistries, tag.getCompound("fluid"));
        }
        this.progress = tag.getInt("progress");
    }
}

