/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.everythingcopper.EverythingCopper;
import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.init.ModRecipeTypes;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ScrapeRecipe
implements CraftingRecipe {
    public final Ingredient input;

    public ScrapeRecipe(Ingredient input) {
        this.input = input;
    }

    public boolean matches(CraftingInput pInput, Level pLevel) {
        boolean hasValidItem = false;
        for (int j = 0; j < pInput.size(); ++j) {
            ItemStack itemStack = pInput.getItem(j);
            if (!itemStack.isEmpty() && this.input.test(itemStack) && (ICopperItem.isWaxed(itemStack) || !ICopperItem.getAge(itemStack).equals("unaffected"))) {
                hasValidItem = true;
                continue;
            }
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return hasValidItem;
    }

    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        ItemStack outputItem = ItemStack.EMPTY;
        for (int j = 0; j < pInput.size(); ++j) {
            ItemStack itemStack = pInput.getItem(j);
            if (itemStack.isEmpty() || !this.input.test(itemStack)) continue;
            outputItem = itemStack.copy();
        }
        if (ICopperItem.isWaxed(outputItem)) {
            ICopperItem.setWaxed(outputItem, false);
        } else {
            ICopperItem.setAge(outputItem, WeatheringUtils.prevState(ICopperItem.getAge(outputItem)));
        }
        return outputItem;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.input.getItems().length > 0 ? this.input.getItems()[0] : ItemStack.EMPTY;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.SCRAPE.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<ScrapeRecipe> {
        private static final MapCodec<ScrapeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("item").forGetter(recipe -> recipe.input)).apply((Applicative)builder, ScrapeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ScrapeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ScrapeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ScrapeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ScrapeRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new ScrapeRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error reading scraping recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, ScrapeRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            }
            catch (Exception e) {
                EverythingCopper.LOGGER.error("Error writing scraping recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

