/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.integration;

import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import cy.jdkdigital.everythingcopper.crafting.recipe.WeatheringRecipe;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.integration.WeatheringRecipeCategory;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"everythingcopper");
    public static RecipeType<WeatheringRecipe> WEATHERING_RECIPE_TYPE = RecipeType.create((String)"everythingcopper", (String)"weathering", WeatheringRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WEATHERING_STATION.get()), new RecipeType[]{WEATHERING_RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new WeatheringRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList weatheringRecipes = new ArrayList();
        BuiltInRegistries.BLOCK.forEach(block -> {
            if (block instanceof WeatheringCopper) {
                WeatheringCopper weatheringBlock = (WeatheringCopper)block;
                weatheringBlock.getNext(block.defaultBlockState()).ifPresent(newState -> {
                    ResourceLocation key = BuiltInRegistries.BLOCK.getKey(block);
                    weatheringRecipes.add(new WeatheringRecipe(ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)("weathering_" + key.getPath())), new ItemStack((ItemLike)block), new ItemStack((ItemLike)newState.getBlock())));
                });
            }
        });
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof ICopperItem) {
                ResourceLocation key = BuiltInRegistries.ITEM.getKey(item);
                ItemStack sourceItem = new ItemStack((ItemLike)item);
                ItemStack newItem = new ItemStack((ItemLike)item);
                while (ICopperItem.canAge(newItem)) {
                    ICopperItem.setAge(newItem, WeatheringUtils.nextState(ICopperItem.getAge(newItem)));
                    weatheringRecipes.add(new WeatheringRecipe(ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)("weathering_" + key.getPath())), sourceItem, newItem.copy()));
                    sourceItem = newItem.copy();
                }
            }
        });
        registration.addRecipes(WEATHERING_RECIPE_TYPE, weatheringRecipes);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }
}

