/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.simpleweather.particles;

import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BaseAshSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.simpleweather.ColorUtils;
import tv.soaryn.simpleweather.SimpleWeather;

public class SnowParticle
extends BaseAshSmokeParticle {
    private static final int COLOR_RGB24 = 0xCCCCCC;
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    protected SnowParticle(ClientLevel level, double xo, double yo, double zo, double vx, double vy, double vz, float scale, SpriteSet spriteSet) {
        super(level, xo, yo, zo, 0.1f, -0.2f, 0.1f, vx, vy, vz, scale, spriteSet, 0.0f, ((Integer)SimpleWeather.ClientConfig.SnowLifetime.get()).intValue(), 0.0125f, true);
        this.rCol = (float)FastColor.ARGB32.red((int)0xCCCCCC) / 255.0f;
        this.gCol = (float)FastColor.ARGB32.green((int)0xCCCCCC) / 255.0f;
        this.bCol = (float)FastColor.ARGB32.blue((int)0xCCCCCC) / 255.0f;
        this.alpha = ((Double)SimpleWeather.ClientConfig.SnowAlpha.get()).floatValue();
        this.scale(((Double)SimpleWeather.ClientConfig.SnowScale.get()).floatValue());
        this.yd += (double)this.random.nextFloat() * -0.1 - (double)0.05f;
        if (SimpleWeather.IsFools) {
            int color = ColorUtils.HSBtoFRGB((float)((System.currentTimeMillis() + (long)this.random.nextInt(10000)) % 10000L) / 10000.0f, 1.0f, 1.0f);
            this.rCol = (float)FastColor.ARGB32.red((int)color) / 255.0f;
            this.gCol = (float)FastColor.ARGB32.green((int)color) / 255.0f;
            this.bCol = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return (Double)SimpleWeather.ClientConfig.SnowAlpha.get() > (double)0.95f ? ParticleRenderType.PARTICLE_SHEET_OPAQUE : ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        if (this.lifetime > 0 && (float)this.age / (float)this.lifetime > 0.7f) {
            this.scale(0.9f);
        }
        if (this.y == this.yo && this.onGround) {
            this.remove();
        }
        this.pos.set(this.x, this.y, this.z);
        if (this.level.isFluidAtPosition((BlockPos)this.pos, Predicate.not(FluidState::isEmpty))) {
            this.remove();
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, ClientLevel level, double xo, double yo, double zo, double ignored1, double ignored2, double ignored3) {
            RandomSource randomsource = level.random;
            double vx = (double)randomsource.nextFloat() * -1.9 * (double)randomsource.nextFloat() * 0.1 + ignored1;
            double vy = (double)randomsource.nextFloat() * -0.5 * (double)randomsource.nextFloat() * 0.5 + ignored2;
            double vz = (double)randomsource.nextFloat() * -1.9 * (double)randomsource.nextFloat() * 0.1 + ignored3;
            return new SnowParticle(level, xo, yo, zo, vx, vy, vz, 1.0f, this.sprites);
        }
    }
}

