/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.Collection;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemHandlerKitchenItemProvider
implements KitchenItemProvider {
    private final IItemHandler itemHandler;

    public ItemHandlerKitchenItemProvider(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        ItemStack slotStack;
        if (cacheHint instanceof ItemHandlerIngredientToken) {
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)cacheHint;
            slotStack = this.itemHandler.getStackInSlot(itemHandlerIngredientToken.slot);
            if (ingredient.test(slotStack) && this.hasUsesLeft(itemHandlerIngredientToken.slot, slotStack, ingredientTokens)) {
                return itemHandlerIngredientToken;
            }
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            slotStack = this.itemHandler.getStackInSlot(i);
            if (!ingredient.test(slotStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ItemHandlerIngredientToken(i);
        }
        return null;
    }

    @Override
    public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        ItemStack slotStack;
        if (cacheHint instanceof ItemHandlerIngredientToken) {
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)cacheHint;
            slotStack = this.itemHandler.getStackInSlot(itemHandlerIngredientToken.slot);
            if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) && this.hasUsesLeft(itemHandlerIngredientToken.slot, slotStack, ingredientTokens)) {
                return itemHandlerIngredientToken;
            }
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            slotStack = this.itemHandler.getStackInSlot(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ItemHandlerIngredientToken(i);
        }
        return null;
    }

    private boolean hasUsesLeft(int slot, ItemStack slotStack, Collection<IngredientToken> ingredientTokens) {
        int uses = slotStack.getCount();
        for (IngredientToken ingredientToken : ingredientTokens) {
            if (!(ingredientToken instanceof ItemHandlerIngredientToken)) continue;
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)ingredientToken;
            if (itemHandlerIngredientToken.slot != slot) continue;
            --uses;
        }
        return uses > 0;
    }

    @Override
    public CacheHint getCacheHint(IngredientToken ingredientToken) {
        CacheHint cacheHint;
        if (ingredientToken instanceof ItemHandlerIngredientToken) {
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)ingredientToken;
            cacheHint = itemHandlerIngredientToken;
        } else {
            cacheHint = CacheHint.NONE;
        }
        return cacheHint;
    }

    public class ItemHandlerIngredientToken
    implements IngredientToken,
    CacheHint {
        private final int slot;

        public ItemHandlerIngredientToken(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack peek() {
            return ItemHandlerKitchenItemProvider.this.itemHandler.getStackInSlot(this.slot);
        }

        @Override
        public ItemStack consume() {
            return ItemHandlerKitchenItemProvider.this.itemHandler.extractItem(this.slot, 1, false);
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            ItemStack restItem = ItemHandlerKitchenItemProvider.this.itemHandler.insertItem(this.slot, itemStack, false);
            if (!restItem.isEmpty()) {
                return ItemHandlerHelper.insertItemStacked((IItemHandler)ItemHandlerKitchenItemProvider.this.itemHandler, (ItemStack)restItem, (boolean)false);
            }
            return ItemStack.EMPTY;
        }
    }
}

