/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.deskbell;

import com.github.minecraftschurlimods.bibliocraft.init.BCSoundEvents;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeskBellBlock
extends BCWaterloggedBlock {
    private static final VoxelShape SHAPE = ShapeUtil.combine(Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), Shapes.box((double)0.40625, (double)0.125, (double)0.40625, (double)0.59375, (double)0.15625, (double)0.59375), Shapes.box((double)0.40625, (double)0.0, (double)0.34375, (double)0.59375, (double)0.09375, (double)0.375), Shapes.box((double)0.40625, (double)0.0, (double)0.625, (double)0.59375, (double)0.09375, (double)0.65625), Shapes.box((double)0.34375, (double)0.0, (double)0.40625, (double)0.375, (double)0.09375, (double)0.59375), Shapes.box((double)0.625, (double)0.0, (double)0.40625, (double)0.65625, (double)0.09375, (double)0.59375), Shapes.box((double)0.484375, (double)0.15625, (double)0.484375, (double)0.515625, (double)0.171875, (double)0.515625), Shapes.box((double)0.46875, (double)0.171875, (double)0.46875, (double)0.53125, (double)0.203125, (double)0.53125));

    public DeskBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.isClientSide() && level.hasNeighborSignal(pos.below())) {
            this.playSound(level, pos);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        this.playSound(level, pos);
        return InteractionResult.SUCCESS;
    }

    private void playSound(Level level, BlockPos pos) {
        level.playSound(null, pos, (SoundEvent)BCSoundEvents.DESK_BELL.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

