/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancylight;

import com.github.minecraftschurlimods.bibliocraft.content.fancylight.AbstractFancyLightBlock;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.Lazy;

public class FancyLanternBlock
extends AbstractFancyLightBlock {
    private static final VoxelShape STANDING_SHAPE = ShapeUtil.combine(Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.0625, (double)0.75), Shapes.box((double)0.3125, (double)0.0625, (double)0.3125, (double)0.375, (double)0.625, (double)0.375), Shapes.box((double)0.625, (double)0.0625, (double)0.3125, (double)0.6875, (double)0.625, (double)0.375), Shapes.box((double)0.3125, (double)0.0625, (double)0.625, (double)0.375, (double)0.625, (double)0.6875), Shapes.box((double)0.625, (double)0.0625, (double)0.625, (double)0.6875, (double)0.625, (double)0.6875), Shapes.box((double)0.34375, (double)0.0625, (double)0.34375, (double)0.65625, (double)0.625, (double)0.65625), Shapes.box((double)0.25, (double)0.625, (double)0.25, (double)0.75, (double)0.6875, (double)0.75), Shapes.box((double)0.3125, (double)0.6875, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), Shapes.box((double)0.375, (double)0.75, (double)0.375, (double)0.625, (double)0.8125, (double)0.625));
    private static final VoxelShape HANGING_SHAPE = ShapeUtil.combine(STANDING_SHAPE, Shapes.box((double)0.40625, (double)0.8125, (double)0.40625, (double)0.59375, (double)1.0, (double)0.59375));
    private static final VoxelShape NORTH_WALL_SHAPE = ShapeUtil.combine(STANDING_SHAPE, Shapes.box((double)0.4375, (double)0.65625, (double)0.9375, (double)0.5625, (double)0.90625, (double)1.0), Shapes.box((double)0.46875, (double)0.70625, (double)0.875, (double)0.53125, (double)0.83125, (double)0.9375), Shapes.box((double)0.46875, (double)0.8125, (double)0.46875, (double)0.53125, (double)0.925, (double)0.9375));
    private static final VoxelShape EAST_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    private static final ResourceLocation DEFAULT_PARTICLE = BCUtil.mcLoc("small_flame");
    private final Lazy<ParticleOptions> particle = Lazy.of(() -> {
        ParticleOptions options;
        Object patt0$temp = BuiltInRegistries.PARTICLE_TYPE.get(particle);
        return patt0$temp instanceof ParticleOptions ? (options = (ParticleOptions)patt0$temp) : null;
    });

    public FancyLanternBlock(BlockBehaviour.Properties properties) {
        this(properties, DEFAULT_PARTICLE);
    }

    public FancyLanternBlock(BlockBehaviour.Properties properties, ResourceLocation particle) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((AbstractFancyLightBlock.Type)((Object)state.getValue((Property)TYPE))) {
            default -> throw new MatchException(null, null);
            case AbstractFancyLightBlock.Type.STANDING -> STANDING_SHAPE;
            case AbstractFancyLightBlock.Type.HANGING -> HANGING_SHAPE;
            case AbstractFancyLightBlock.Type.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        yield NORTH_WALL_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_WALL_SHAPE;
                    }
                    case WEST: {
                        yield WEST_WALL_SHAPE;
                    }
                    case EAST: 
                }
                yield EAST_WALL_SHAPE;
            }
        };
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        Vec3 offset = Vec3.atCenterOf((Vec3i)pos);
        if (random.nextFloat() < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
        }
        level.addParticle(BCUtil.nonNull((ParticleOptions)this.particle.get()), offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty() && player.getAbilities().mayBuild && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 11);
            level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        return itemAbility == ItemAbilities.FIRESTARTER_LIGHT && (Boolean)state.getValue((Property)LIT) == false ? (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)) : super.getToolModifiedState(state, context, itemAbility, simulate);
    }
}

