/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableBlock;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMenu;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMode;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipe;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipeInput;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableSetRecipePacket;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableTank;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlocks;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.CodecUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCMenuBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.slot.HasToggleableSlots;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class PrintingTableBlockEntity
extends BCMenuBlockEntity
implements HasToggleableSlots {
    private static final String MODE_KEY = "mode";
    private static final String DURATION_KEY = "duration";
    private static final String PLAYER_NAME_KEY = "player_name";
    private static final String DISABLED_SLOTS_KEY = "disabled_slots";
    private static final int SLOT_DISABLED = 1;
    private static final int SLOT_ENABLED = 0;
    private final PrintingTableTank tank;
    private final Direction[] directions;
    private final boolean[] disabledSlots = new boolean[9];
    private PrintingTableRecipe recipe;
    private PrintingTableRecipeInput recipeInput;
    private PrintingTableMode mode = PrintingTableMode.BIND;
    private int levelCost = 0;
    private int duration = 0;
    private int maxDuration = 0;
    private Component playerName = null;

    public PrintingTableBlockEntity(BlockPos pos, BlockState state) {
        super(BCBlockEntities.PRINTING_TABLE.get(), 11, PrintingTableBlockEntity.defaultName("printing_table"), pos, state);
        this.tank = new PrintingTableTank(this, state.is(BCBlocks.IRON_PRINTING_TABLE));
        Direction facing = (Direction)state.getValue((Property)PrintingTableBlock.FACING);
        this.directions = new Direction[]{Direction.UP, facing, facing.getClockWise(), facing.getOpposite(), facing.getCounterClockWise(), Direction.DOWN};
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PrintingTableBlockEntity blockEntity) {
        if (blockEntity.duration < blockEntity.maxDuration && blockEntity.isExperienceFull()) {
            ++blockEntity.duration;
        }
        if (blockEntity.duration >= blockEntity.maxDuration) {
            blockEntity.duration = 0;
            if (!level.isClientSide()) {
                blockEntity.finishRecipe();
            }
        }
        if (!blockEntity.isExperienceFull()) {
            blockEntity.pullExperience();
        }
        blockEntity.setChanged();
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new PrintingTableMenu(id, inventory, this);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setMode(CodecUtil.decodeNbt(PrintingTableMode.CODEC, tag.get(MODE_KEY)));
        this.duration = tag.getInt(DURATION_KEY);
        if (tag.contains(PLAYER_NAME_KEY, 8)) {
            this.playerName = Component.Serializer.fromJson((String)tag.getString(PLAYER_NAME_KEY), (HolderLookup.Provider)registries);
        }
        this.tank.loadAdditional(tag);
        int[] tagSlots = tag.getIntArray(DISABLED_SLOTS_KEY);
        for (int i = 0; i < 9; ++i) {
            this.disabledSlots[i] = this.canDisableSlot(i) && tagSlots[i] == 1;
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(MODE_KEY, CodecUtil.encodeNbt(PrintingTableMode.CODEC, this.getMode()));
        tag.putInt(DURATION_KEY, this.duration);
        if (this.playerName != null) {
            tag.putString(PLAYER_NAME_KEY, Component.Serializer.toJson((Component)this.playerName, (HolderLookup.Provider)registries));
        }
        this.tank.saveAdditional(tag);
        int[] tagSlots = new int[9];
        for (int i = 0; i < 9; ++i) {
            tagSlots[i] = this.disabledSlots[i] ? 1 : 0;
        }
        tag.putIntArray(DISABLED_SLOTS_KEY, tagSlots);
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        if (this.isSlotDisabled(slot) && !stack.isEmpty()) {
            this.setSlotDisabled(slot, false);
        }
        super.setItem(slot, stack);
        this.recipeInput = null;
        if (this.recipe == null || !this.recipe.matches(this.getRecipeInput(), BCUtil.nonNull(this.getLevel()))) {
            this.calculateRecipe(false);
            this.setChanged();
        }
    }

    @Override
    public void setSlotDisabled(int slot, boolean disabled) {
        if (!this.canDisableSlot(slot)) {
            return;
        }
        this.disabledSlots[slot] = disabled;
        this.setChanged();
    }

    @Override
    public boolean isSlotDisabled(int slot) {
        return this.isCraftingSlot(slot) && this.disabledSlots[slot];
    }

    @Override
    public boolean canDisableSlot(int slot) {
        return this.isCraftingSlot(slot) && this.getItem(slot).isEmpty();
    }

    public void onLoad() {
        if (!this.level().isClientSide()) {
            this.calculateRecipe(true);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new PrintingTableSetRecipePacket(this.getBlockPos(), 0, 0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public PrintingTableTank getFluidCapability() {
        return this.tank;
    }

    public PrintingTableMode getMode() {
        return this.mode;
    }

    public void setMode(PrintingTableMode mode) {
        this.mode = mode;
        this.calculateRecipe(false);
        this.setChanged();
    }

    public Component getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(Component playerName) {
        this.playerName = playerName;
    }

    public int getExperience() {
        return this.tank.getExperience();
    }

    public void addExperience(int experience) {
        this.tank.addExperience(experience);
        this.setChanged();
    }

    public float getProgress() {
        return !this.isExperienceFull() || this.maxDuration == 0 ? 0.0f : (float)this.duration / (float)this.maxDuration;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public int getExperienceCost() {
        return BCUtil.getExperienceForLevel(this.levelCost);
    }

    public boolean isExperienceFull() {
        int experienceCost = this.getExperienceCost();
        return experienceCost <= 0 || this.getExperience() >= experienceCost;
    }

    public void setFromPacket(PrintingTableSetRecipePacket packet) {
        this.duration = packet.duration();
        this.maxDuration = packet.maxDuration();
        this.levelCost = packet.levelCost();
        this.tank.clear();
        this.setChanged();
    }

    private void finishRecipe() {
        if (this.recipe == null) {
            return;
        }
        NonNullList remainingItems = this.recipe.getRemainingItems(this.getRecipeInput());
        ItemStack stack = this.getItem(10);
        ItemStack result = this.recipe.postProcess(this.recipe.assemble(this.getRecipeInput(), (HolderLookup.Provider)this.level().registryAccess()), this);
        if (!stack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)result)) {
            return;
        }
        result.setCount(stack.getCount() + 1);
        this.setItem(10, result);
        IntStream.range(0, 10).mapToObj(this::getItem).forEach(e -> e.shrink(1));
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack remaining = (ItemStack)remainingItems.get(i);
            if (remaining.isEmpty()) continue;
            this.setItem(i, remaining.copy());
        }
        this.calculateRecipe(false);
    }

    private void pullExperience() {
        List<Fluid> fluids = this.level().registryAccess().lookupOrThrow(Registries.FLUID).getOrThrow(Tags.Fluids.EXPERIENCE).stream().map(Holder::value).toList();
        for (Direction direction : this.directions) {
            IFluidHandler capability = (IFluidHandler)this.level().getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().offset(direction.getNormal()), (Object)direction);
            if (capability == null) continue;
            for (Fluid fluid : fluids) {
                this.tank.fillFromCapability(capability, fluid);
                if (!this.isExperienceFull()) continue;
                return;
            }
        }
    }

    private void calculateRecipe(boolean onLoad) {
        ItemStack output;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.recipe = serverLevel.getRecipeManager().getRecipesFor((RecipeType)BCRecipes.PRINTING_TABLE.get(), (RecipeInput)this.getRecipeInput(), (Level)serverLevel).stream().map(RecipeHolder::value).filter(e -> e.getMode() == this.mode).findFirst().orElse(null);
        if (!(this.recipe == null || (output = this.getItem(10)).isEmpty() || output.getCount() < output.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)this.recipe.assemble(this.getRecipeInput(), (HolderLookup.Provider)this.level().registryAccess()), (ItemStack)output))) {
            this.recipe = null;
        }
        if (!onLoad) {
            this.duration = 0;
        }
        this.maxDuration = this.recipe == null ? 0 : this.recipe.getDuration();
        this.levelCost = this.recipe == null ? 0 : this.recipe.getExperienceLevelCost(this.recipeInput.right().copy(), serverLevel);
        this.tank.clear();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new PrintingTableSetRecipePacket(this.getBlockPos(), this.duration, this.maxDuration, this.levelCost), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private PrintingTableRecipeInput getRecipeInput() {
        if (this.recipeInput == null) {
            this.recipeInput = new PrintingTableRecipeInput(IntStream.range(0, 9).mapToObj(this::getItem).toList(), this.getItem(9));
        }
        return this.recipeInput;
    }

    private boolean isCraftingSlot(int slot) {
        return slot >= 0 && slot < 9;
    }
}

