/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.block;

import com.github.minecraftschurlimods.bibliocraft.util.block.BCBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BCMenuBlockEntity
extends BCBlockEntity
implements MenuProvider,
Nameable {
    private static final String NAME_KEY = "CustomName";
    private final Component defaultName;
    private Component name;

    public BCMenuBlockEntity(BlockEntityType<?> type, int containerSize, Component defaultName, BlockPos pos, BlockState state) {
        super(type, containerSize, pos, state);
        this.defaultName = defaultName;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public Component getName() {
        return this.name != null ? this.name : this.defaultName;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public static Component defaultName(String name) {
        return Component.translatable((String)("container.bibliocraft." + name));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return BaseContainerBlockEntity.canUnlock((Player)player, (LockCode)this.getLockKey(), (Component)this.getDisplayName()) ? this.createMenu(id, inventory) : null;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(NAME_KEY, 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString(NAME_KEY), (HolderLookup.Provider)registries);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.name != null) {
            tag.putString(NAME_KEY, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }
}

