/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.toolbelt.BeltFinderBeltSlot;
import dev.gigaherz.toolbelt.BeltFinderCurios;
import dev.gigaherz.toolbelt.Conditions;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.belt.BeltIngredient;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.common.BeltContainer;
import dev.gigaherz.toolbelt.common.BeltScreen;
import dev.gigaherz.toolbelt.integration.SewingKitIntegration;
import dev.gigaherz.toolbelt.integration.SewingUpgradeRecipe;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.network.ContainerSlotsHack;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import dev.gigaherz.toolbelt.network.SwapItems;
import dev.gigaherz.toolbelt.network.SyncBeltSlotContents;
import dev.gigaherz.toolbelt.slot.BeltAttachment;
import dev.gigaherz.toolbelt.slot.BeltSlotMenu;
import dev.gigaherz.toolbelt.slot.BeltSlotScreen;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="toolbelt")
public class ToolBelt {
    public static final String MODID = "toolbelt";
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"toolbelt");
    private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"toolbelt");
    private static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"toolbelt");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"toolbelt");
    private static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"toolbelt");
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<Conditions.EnableNormalCrafting>> ENABLE_NORMAL = CONDITION_SERIALIZERS.register("enable_normal_crafting", () -> Conditions.EnableNormalCrafting.CODEC);
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<Conditions.EnableSewingCrafting>> ENABLE_SEWING = CONDITION_SERIALIZERS.register("enable_sewing_crafting", () -> Conditions.EnableSewingCrafting.CODEC);
    public static DeferredItem<ToolBeltItem> BELT = ITEMS.register("belt", () -> new ToolBeltItem(new Item.Properties().stacksTo(1)));
    public static DeferredItem<Item> POUCH = ITEMS.register("pouch", () -> new Item(new Item.Properties()));
    public static DeferredHolder<MenuType<?>, MenuType<BeltSlotMenu>> BELT_SLOT_MENU = MENU_TYPES.register("belt_slot_container", () -> new MenuType(BeltSlotMenu::new, FeatureFlags.DEFAULT_FLAGS));
    public static DeferredHolder<MenuType<?>, MenuType<BeltContainer>> BELT_MENU = MENU_TYPES.register("belt_container", () -> IMenuTypeExtension.create(BeltContainer::new));
    public static DeferredHolder<IngredientType<?>, IngredientType<BeltIngredient>> BELT_INGREDIENT = INGREDIENT_TYPES.register("belt_upgrade_level", () -> new IngredientType(BeltIngredient.CODEC));
    public static DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> BELT_SIZE = DATA_COMPONENT_TYPES.register("belt_size", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build());
    public static boolean controllableEnabled;
    public static final int[] XP_COSTS;

    public ToolBelt(ModContainer container, IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        INGREDIENT_TYPES.register(modEventBus);
        CONDITION_SERIALIZERS.register(modEventBus);
        DATA_COMPONENT_TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::modConfigLoad);
        modEventBus.addListener(this::modConfigReload);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::addItemsToTabs);
        modEventBus.addListener(this::registerPackets);
        modEventBus.addListener(ToolBeltItem::register);
        NeoForge.EVENT_BUS.addListener(this::anvilChange);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigData.COMMON_SPEC);
        BeltAttachment.register(modEventBus);
        if (ModList.get().isLoaded("sewingkit")) {
            SewingKitIntegration.init(modEventBus);
        }
    }

    private void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(BELT);
            event.accept(POUCH);
        }
    }

    public void gatherData(GatherDataEvent event) {
        DataGen.gatherData(event);
    }

    public void modConfigLoad(ModConfigEvent.Loading event) {
        this.reloadConfigs(event.getConfig());
    }

    public void modConfigReload(ModConfigEvent.Reloading event) {
        this.reloadConfigs(event.getConfig());
    }

    private void reloadConfigs(ModConfig config) {
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        } else if (config.getSpec() == ConfigData.COMMON_SPEC) {
            ConfigData.refreshCommon();
        } else if (config.getSpec() == ConfigData.SERVER_SPEC) {
            ConfigData.refreshServer();
        }
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0");
        registrar.playToServer(SwapItems.TYPE, SwapItems.STREAM_CODEC, SwapItems::handle);
        registrar.playToServer(OpenBeltSlotInventory.TYPE, OpenBeltSlotInventory.STREAM_CODEC, OpenBeltSlotInventory::handle);
        registrar.playToServer(ContainerSlotsHack.TYPE, ContainerSlotsHack.STREAM_CODEC, ContainerSlotsHack::handle);
        registrar.playToClient(BeltContentsChange.TYPE, BeltContentsChange.STREAM_CODEC, BeltContentsChange::handle);
        registrar.playToClient(SyncBeltSlotContents.TYPE, SyncBeltSlotContents.STREAM_CODEC, SyncBeltSlotContents::handle);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        BeltFinderBeltSlot.initBaubles();
        if (ModList.get().isLoaded("curios")) {
            BeltFinderCurios.initCurios();
        }
    }

    public static int getUpgradeXP(ItemStack stack) {
        int slots = ToolBeltItem.getSlotsCount(stack);
        if (slots >= 9) {
            return -1;
        }
        if (slots < 2) {
            return 1;
        }
        return XP_COSTS[slots - 2];
    }

    public void anvilChange(AnvilUpdateEvent ev) {
        if (!ConfigData.enableAnvilUpgrading) {
            return;
        }
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.getCount() <= 0 || left.getItem() != BELT.get()) {
            return;
        }
        if (right.getCount() <= 0 || right.getItem() != POUCH.get()) {
            return;
        }
        int cost = ToolBelt.getUpgradeXP(left);
        if (cost < 0) {
            ev.setCanceled(true);
            return;
        }
        ev.setCost((long)cost);
        ev.setMaterialCost(1);
        ev.setOutput(ToolBeltItem.makeUpgradedStack(left));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private static TagKey<Item> itemTag(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)name));
    }

    static {
        XP_COSTS = new int[]{3, 5, 8, 12, 15, 20, 30};
    }

    public static class DataGen {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            gen.addProvider(event.includeServer(), (DataProvider)new Recipes(gen.getPackOutput(), event.getLookupProvider()));
        }

        private static class Recipes
        extends RecipeProvider
        implements IConditionBuilder {
            public Recipes(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
                super(output, lookup);
            }

            protected void buildRecipes(RecipeOutput consumer) {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)BELT.get())).pattern("sls").pattern("l l").pattern("lil").define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING})).define(Character.valueOf('l'), Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER})).define(Character.valueOf('i'), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})).unlockedBy("has_leather", Recipes.has(ToolBelt.itemTag("forge:leather"))).save(consumer.withConditions(new ICondition[]{new Conditions.EnableNormalCrafting()}));
                SewingRecipeBuilder.begin((RecipeCategory)RecipeCategory.TOOLS, (Item)((Item)BELT.get())).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{SewingKitMod.LEATHER_STRIP}), 2).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{SewingKitMod.LEATHER_SHEET}), 3).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), 1).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}), 2).addCriterion("has_leather", Recipes.has(ToolBelt.itemTag("forge:leather"))).save(consumer.withConditions(new ICondition[]{this.modLoaded("sewingkit"), new Conditions.EnableSewingCrafting()}), this.sewingRecipeId((DeferredHolder<?, ?>)BELT));
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)POUCH.get())).pattern("sgs").pattern("l l").pattern("sls").define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING})).define(Character.valueOf('l'), Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER})).define(Character.valueOf('g'), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})).unlockedBy("has_leather", Recipes.has(ToolBelt.itemTag("forge:leather"))).save(consumer.withConditions(new ICondition[]{new Conditions.EnableNormalCrafting()}));
                SewingRecipeBuilder.begin((RecipeCategory)RecipeCategory.TOOLS, (Item)((Item)POUCH.get())).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SewingKitMod.LEATHER_STRIP.get()}), 2).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SewingKitMod.LEATHER_SHEET.get()}), 3).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING})).addCriterion("has_leather", Recipes.has(ToolBelt.itemTag("forge:leather"))).save(consumer.withConditions(new ICondition[]{this.modLoaded("sewingkit"), new Conditions.EnableSewingCrafting()}), this.sewingRecipeId((DeferredHolder<?, ?>)POUCH));
                List<TagKey> needleTiers = List.of(SewingKitMod.WOOD_OR_HIGHER, SewingKitMod.BONE_OR_HIGHER, SewingKitMod.IRON_OR_HIGHER, SewingKitMod.IRON_OR_HIGHER, SewingKitMod.DIAMOND_OR_HIGHER, SewingKitMod.DIAMOND_OR_HIGHER, SewingKitMod.NETHERITE_OR_HIGHER);
                for (int i = 2; i < 9; ++i) {
                    ResourceLocation beltId = BELT.getId();
                    SewingUpgradeRecipe.builder(ToolBeltItem.of(i + 1)).withTool(needleTiers.get(i - 2)).addMaterial(BeltIngredient.withLevel(i).toVanilla()).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)POUCH.get()})).addMaterial(Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING})).setGroup("toolbelt_belt_upgrade").addCriterion("has_leather", Recipes.has(ToolBelt.itemTag("forge:leather"))).save(consumer.withConditions(new ICondition[]{this.modLoaded("sewingkit"), new Conditions.EnableSewingCrafting()}), ResourceLocation.fromNamespaceAndPath((String)beltId.getNamespace(), (String)(beltId.getPath() + "_upgrade_" + (i - 1) + "_via_sewing")));
                }
            }

            private ResourceLocation sewingRecipeId(DeferredHolder<?, ?> item) {
                return this.sewingRecipeId(item.getId());
            }

            private ResourceLocation sewingRecipeId(ResourceLocation item) {
                return ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)(item.getPath() + "_via_sewing"));
            }
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="toolbelt", bus=EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void menuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)BELT_MENU.get(), BeltScreen::new);
            event.register((MenuType)BELT_SLOT_MENU.get(), BeltSlotScreen::new);
        }
    }
}

