/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.belt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class BeltIngredient
implements ICustomIngredient {
    public static final MapCodec<BeltIngredient> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("size").forGetter(obj -> obj.size)).apply((Applicative)inst, BeltIngredient::new));
    private final int size;

    public static BeltIngredient withLevel(int level) {
        return new BeltIngredient(level);
    }

    protected BeltIngredient(int size) {
        this.size = size;
    }

    public boolean test(ItemStack stack) {
        return stack.getItem() == ToolBelt.BELT.get() && ToolBeltItem.getSlotsCount(stack) == this.size;
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(((ToolBeltItem)ToolBelt.BELT.get()).forSize(this.size));
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ToolBelt.BELT_INGREDIENT.get();
    }
}

