/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;

public interface LootRule
extends CodecProvider<LootRule> {
    public static final CodecMap<LootRule> CODEC = new CodecMap("Loot Rule");

    public void execute(ItemStack var1, LootRarity var2, GenContext var3);

    public static void initCodecs() {
        LootRule.register("component", ComponentLootRule.CODEC);
        LootRule.register("affix", AffixLootRule.CODEC);
        LootRule.register("socket", SocketLootRule.CODEC);
        LootRule.register("durability", DurabilityLootRule.CODEC);
        LootRule.register("chanced", ChancedLootRule.CODEC);
        LootRule.register("combined", CombinedLootRule.CODEC);
        LootRule.register("select", SelectLootRule.CODEC);
    }

    private static void register(String id, Codec<? extends LootRule> codec) {
        CODEC.register(Apotheosis.loc(id), codec);
    }

    public record ComponentLootRule(DataComponentPatch components) implements LootRule
    {
        public static Codec<ComponentLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DataComponentPatch.CODEC.fieldOf("components").forGetter(ComponentLootRule::components)).apply((Applicative)inst, ComponentLootRule::new));

        public Codec<ComponentLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            stack.applyComponents(this.components);
        }
    }

    public record AffixLootRule(AffixType type) implements LootRule
    {
        public static Codec<AffixLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)AffixType.CODEC.fieldOf("affix_type").forGetter(AffixLootRule::type)).apply((Applicative)inst, AffixLootRule::new));

        public Codec<AffixLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            List<WeightedEntry.Wrapper<Affix>> available = LootController.getWeightedAffixes(stack, rarity, this.type, ctx);
            int weight = WeightedRandom.getTotalWeight(available);
            if (available.size() == 0 && weight == 0) {
                Apotheosis.LOGGER.error("Failed to execute AffixLootRule (no affixes available) {}/{}/{}/{}!", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)RarityRegistry.INSTANCE.getKey(rarity), (Object)this.type);
                return;
            }
            Affix selected = (Affix)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)ctx.rand(), available, (int)weight).get()).data();
            ItemAffixes.Builder builder = ((ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY)).toBuilder();
            builder.upgrade((DynamicHolder<Affix>)AffixRegistry.INSTANCE.holder(selected), ctx.rand().nextFloat());
            AffixHelper.setAffixes(stack, builder.build());
        }
    }

    public record SocketLootRule(int min, int max) implements LootRule
    {
        public static Codec<SocketLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)16).fieldOf("min").forGetter(SocketLootRule::min), (App)Codec.intRange((int)1, (int)16).fieldOf("max").forGetter(SocketLootRule::max)).apply((Applicative)inst, SocketLootRule::new));

        public Codec<SocketLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            int sockets = SocketHelper.getSockets(stack);
            int newSockets = ctx.rand().nextIntBetweenInclusive(this.min, this.max);
            if (newSockets > sockets) {
                SocketHelper.setSockets(stack, newSockets);
            }
        }
    }

    public record DurabilityLootRule(float min, float max) implements LootRule
    {
        public static Codec<DurabilityLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("min").forGetter(DurabilityLootRule::min), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("max").forGetter(DurabilityLootRule::max)).apply((Applicative)inst, DurabilityLootRule::new));

        public Codec<DurabilityLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            stack.set(Apoth.Components.DURABILITY_BONUS, (Object)Float.valueOf(Mth.lerp((float)ctx.rand().nextFloat(), (float)this.min, (float)this.max)));
        }
    }

    public record ChancedLootRule(float chance, LootRule rule) implements LootRule
    {
        public static Codec<ChancedLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedLootRule::chance), (App)CODEC.fieldOf("rule").forGetter(ChancedLootRule::rule)).apply((Applicative)inst, ChancedLootRule::new));

        public Codec<ChancedLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            if (ctx.rand().nextFloat() <= this.chance) {
                this.rule.execute(stack, rarity, ctx);
            }
        }
    }

    public record CombinedLootRule(List<LootRule> rules) implements LootRule
    {
        public static Codec<CombinedLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.listOf().fieldOf("rules").forGetter(CombinedLootRule::rules)).apply((Applicative)inst, CombinedLootRule::new));

        public Codec<CombinedLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            for (LootRule rule : this.rules) {
                rule.execute(stack, rarity, ctx);
            }
        }
    }

    public record SelectLootRule(float chance, LootRule ifTrue, LootRule ifFalse) implements LootRule
    {
        public static Codec<SelectLootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(SelectLootRule::chance), (App)CODEC.fieldOf("if_true").forGetter(SelectLootRule::ifTrue), (App)CODEC.fieldOf("if_false").forGetter(SelectLootRule::ifFalse)).apply((Applicative)inst, SelectLootRule::new));

        public Codec<SelectLootRule> getCodec() {
            return CODEC;
        }

        @Override
        public void execute(ItemStack stack, LootRarity rarity, GenContext ctx) {
            if (ctx.rand().nextFloat() <= this.chance) {
                this.ifTrue.execute(stack, rarity, ctx);
            } else {
                this.ifFalse.execute(stack, rarity, ctx);
            }
        }
    }
}

