/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public record RarityOverride(LootCategory category, Map<LootRarity, List<LootRule>> overrides) implements CodecProvider<RarityOverride>
{
    public static final Codec<RarityOverride> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootCategory.CODEC.fieldOf("category").forGetter(RarityOverride::category), (App)Codec.unboundedMap(LootRarity.CODEC, (Codec)LootRule.CODEC.listOf()).fieldOf("overrides").forGetter(RarityOverride::overrides)).apply((Applicative)inst, RarityOverride::new));

    public Codec<? extends RarityOverride> getCodec() {
        return CODEC;
    }

    public boolean hasRules(LootRarity rarity) {
        return this.overrides.containsKey(rarity);
    }

    @Nullable
    public List<LootRule> getRules(LootRarity rarity) {
        return this.overrides.get(rarity);
    }

    public static Builder builder(LootCategory category) {
        return new Builder(category);
    }

    public static class Builder {
        private final LootCategory category;
        private final Map<LootRarity, List<LootRule>> overrides = new IdentityHashMap<LootRarity, List<LootRule>>();

        public Builder(LootCategory category) {
            this.category = category;
        }

        public Builder override(LootRarity rarity, UnaryOperator<RuleListBuilder> config) {
            final ArrayList list = new ArrayList();
            config.apply(new RuleListBuilder(){

                @Override
                public RuleListBuilder rule(LootRule rule) {
                    list.add(rule);
                    return this;
                }
            });
            this.overrides.put(rarity, list);
            return this;
        }

        public RarityOverride build() {
            return new RarityOverride(this.category, this.overrides);
        }

        public static interface RuleListBuilder {
            public RuleListBuilder rule(LootRule var1);
        }
    }
}

