/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.loot.functions.ContextualLootFunction;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ReforgeItemFunction
extends ContextualLootFunction {
    public static final MapCodec<ReforgeItemFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> ReforgeItemFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)PlaceboCodecs.setOf((Codec)RarityRegistry.INSTANCE.holderCodec()).optionalFieldOf("rarities", Set.of()).forGetter(a -> a.rarities)).apply((Applicative)inst, ReforgeItemFunction::new));
    public static final LootItemFunctionType<ReforgeItemFunction> TYPE = new LootItemFunctionType(CODEC);
    private final Set<DynamicHolder<LootRarity>> rarities;

    public ReforgeItemFunction(List<LootItemCondition> predicates, Set<DynamicHolder<LootRarity>> rarities) {
        super(predicates);
        this.rarities = rarities;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return TYPE;
    }

    @Override
    protected ItemStack run(ItemStack stack, LootContext ctx, GenContext gCtx) {
        LootCategory cat = LootCategory.forItem(stack);
        if (!cat.isNone()) {
            LootRarity rarity = LootRarity.randomFromHolders(gCtx, this.rarities);
            ItemStack reforged = LootController.createLootItem(stack, rarity, gCtx);
            return reforged;
        }
        return stack;
    }
}

