/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, remap=false)
public abstract class MHFMixinLivingEntity {
    @Unique
    @Nullable
    private Float actualHealth = null;

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void maxhealthfix$readAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        float savedHealth;
        if (tag.contains("Health", 99) && (savedHealth = tag.getFloat("Health")) > this.getMaxHealth() && savedHealth > 0.0f) {
            this.actualHealth = Float.valueOf(savedHealth);
        }
    }

    @Inject(method={"detectEquipmentUpdates()V"}, at={@At(value="RETURN")})
    private void maxhealthfix$detectEquipmentUpdates(CallbackInfo callback) {
        if (this.actualHealth != null) {
            if (this.actualHealth.floatValue() > 0.0f && this.actualHealth.floatValue() > this.getHealth()) {
                this.setHealth(this.actualHealth.floatValue());
            }
            this.actualHealth = null;
        }
    }

    @Shadow
    public abstract float getMaxHealth();

    @Shadow
    public abstract float getHealth();

    @Shadow
    public abstract void setHealth(float var1);
}

