/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin.client;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkeletonModel.class}, remap=false)
public abstract class SkeletonModelMixin
extends HumanoidModel<Mob> {
    public SkeletonModelMixin(ModelPart root) {
        super(root);
    }

    @Inject(method={"setupAnim"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;isAggressive()Z")}, cancellable=true)
    public void apoth_setupCrossbowAnimations(Mob entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (entity.getMainHandItem().getItem() instanceof CrossbowItem) {
            if (entity.isUsingItem()) {
                AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, (LivingEntity)entity, (boolean)true);
            } else {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
            }
            ci.cancel();
        }
    }
}

