/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.registries;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.types.Elite;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredDynamicRegistry;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class EliteRegistry
extends TieredDynamicRegistry<Elite> {
    public static final EliteRegistry INSTANCE = new EliteRegistry();

    public EliteRegistry() {
        super(Apotheosis.LOGGER, "apothic_elites", false, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("elite"), Elite.CODEC);
    }

    @Nullable
    public Elite getRandomItem(GenContext ctx, Entity target) {
        return (Elite)this.getRandomItem(ctx, Constraints.eval(ctx), IEntityMatch.matches(target));
    }

    public static interface IEntityMatch {
        public HolderSet<EntityType<?>> getEntities();

        public static <T extends IEntityMatch> Predicate<T> matches(EntityType<?> type) {
            return obj -> {
                HolderSet<EntityType<?>> types = obj.getEntities();
                return types == null || types.size() == 0 || types.contains(BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)type));
            };
        }

        public static <T extends IEntityMatch> Predicate<T> matches(Entity entity) {
            return IEntityMatch.matches(entity.getType());
        }
    }
}

