/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.mobs.util.EntityModifier;
import dev.shadowsoffire.apotheosis.mobs.util.SpawnCondition;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;

public record Augmentation(float chance, Constraints constraints, List<SpawnCondition> conditions, List<EntityModifier> modifiers) implements CodecProvider<Augmentation>
{
    public static final Codec<Augmentation> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("application_chance").forGetter(Augmentation::chance), (App)Constraints.CODEC.optionalFieldOf("constraints", (Object)Constraints.EMPTY).forGetter(Augmentation::constraints), (App)SpawnCondition.CODEC.listOf().optionalFieldOf("conditions", Collections.emptyList()).forGetter(Augmentation::conditions), (App)EntityModifier.CODEC.listOf().fieldOf("modifiers").forGetter(Augmentation::modifiers)).apply((Applicative)inst, Augmentation::new));

    public Codec<? extends Augmentation> getCodec() {
        return CODEC;
    }

    public boolean canApply(ServerLevelAccessor level, Mob mob, MobSpawnType type, GenContext ctx) {
        if (!this.constraints.test(ctx)) {
            return false;
        }
        return SpawnCondition.checkAll(this.conditions, mob, level, type);
    }

    public void apply(Mob mob, GenContext ctx) {
        for (EntityModifier em : this.modifiers) {
            em.apply(mob, ctx);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float chance = 1.0f;
        private Constraints constraints = Constraints.EMPTY;
        private List<SpawnCondition> conditions = new ArrayList<SpawnCondition>();
        private List<EntityModifier> modifiers = new ArrayList<EntityModifier>();

        public Builder chance(float chance) {
            this.chance = chance;
            return this;
        }

        public Builder constraints(Constraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public Builder conditions(SpawnCondition ... condition) {
            this.conditions.addAll(Arrays.asList(condition));
            return this;
        }

        public Builder modifiers(EntityModifier ... modifiers) {
            this.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        public Augmentation build() {
            if (this.modifiers.isEmpty()) {
                throw new IllegalStateException("At least one modifier must be added");
            }
            return new Augmentation(this.chance, this.constraints, this.conditions, this.modifiers);
        }
    }
}

