/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class AttributeBonus
extends GemBonus {
    public static Codec<AttributeBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AttributeBonus.gemClass(), (App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)Purity.mapCodec(Codec.DOUBLE).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, AttributeBonus::new));
    protected final Holder<Attribute> attribute;
    protected final AttributeModifier.Operation operation;
    protected final Map<Purity, Double> values;

    public AttributeBonus(GemClass gemClass, Holder<Attribute> attr, AttributeModifier.Operation op, Map<Purity, Double> values) {
        super(gemClass);
        this.attribute = attr;
        this.operation = op;
        this.values = values;
    }

    @Override
    public void addModifiers(GemInstance gem, StackAttributeModifiersEvent event) {
        event.addModifier(this.attribute, this.createModifier(gem), gem.category().getSlots());
    }

    @Override
    public void skipModifierIds(GemInstance gem, Consumer<ResourceLocation> skip) {
        skip.accept(AttributeBonus.makeUniqueId(gem));
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        return ((Attribute)this.attribute.value()).toComponent(this.createModifier(gem), ctx.flag());
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public AttributeModifier createModifier(GemView gem) {
        double value = this.values.get(gem.purity());
        return new AttributeModifier(AttributeBonus.makeUniqueId(gem), value, this.operation);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private final Map<Purity, Double> values = new HashMap<Purity, Double>();
        private Holder<Attribute> attribute;
        private AttributeModifier.Operation operation;

        private Builder() {
        }

        public Builder attr(Holder<Attribute> attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder op(AttributeModifier.Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder value(Purity purity, double value) {
            this.values.put(purity, value);
            return this;
        }

        @Override
        public AttributeBonus build(GemClass gClass) {
            return new AttributeBonus(gClass, this.attribute, this.operation, this.values);
        }
    }
}

