/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.tiers.augments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public record AttributeAugment(WorldTier tier, TierAugment.Target target, int sortIndex, RandomAttributeModifier modifier, ResourceLocation id) implements TierAugment
{
    public static final Codec<AttributeAugment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WorldTier.CODEC.fieldOf("tier").forGetter(TierAugment::tier), (App)TierAugment.Target.CODEC.fieldOf("target").forGetter(TierAugment::target), (App)Codec.intRange((int)0, (int)2000).optionalFieldOf("sort_index", (Object)1000).forGetter(TierAugment::sortIndex), (App)RandomAttributeModifier.CONSTANT_CODEC.fieldOf("modifier").forGetter(AttributeAugment::modifier), (App)ResourceLocation.CODEC.fieldOf("modifier_id").forGetter(AttributeAugment::id)).apply((Applicative)inst, AttributeAugment::new));

    public Codec<? extends AttributeAugment> getCodec() {
        return CODEC;
    }

    @Override
    public void apply(ServerLevelAccessor level, LivingEntity entity) {
        AttributeInstance inst = entity.getAttribute(this.modifier.attribute());
        if (inst != null) {
            AttributeModifier modif = this.modifier.createDeterministic(this.id);
            inst.addOrReplacePermanentModifier(modif);
        }
    }

    @Override
    public void remove(ServerLevelAccessor level, LivingEntity entity) {
        AttributeInstance inst = entity.getAttribute(this.modifier.attribute());
        if (inst != null) {
            inst.removeModifier(this.id);
        }
    }

    @Override
    public Component getDescription(AttributeTooltipContext ctx) {
        AttributeModifier modif = this.modifier.createDeterministic(this.id);
        return ((Attribute)this.modifier.attribute().value()).toComponent(modif, ctx.flag());
    }
}

