/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import java.util.Map;

public record PresetSpawnerStats(Map<SpawnerStat<?>, Object> stats) {
    public static final Codec<PresetSpawnerStats> CODEC = Codec.dispatchedMap((Codec)SpawnerStats.REGISTRY.byNameCodec(), SpawnerStat::getValueCodec).xmap(PresetSpawnerStats::new, PresetSpawnerStats::stats);
    private static Map<SpawnerStat<?>, Object> DEFAULT_STATS = ImmutableMap.builder().put((Object)SpawnerStats.MIN_DELAY, (Object)200).put((Object)SpawnerStats.MAX_DELAY, (Object)800).put((Object)SpawnerStats.SPAWN_COUNT, (Object)4).put((Object)SpawnerStats.MAX_NEARBY_ENTITIES, (Object)6).put((Object)SpawnerStats.SPAWN_RANGE, (Object)4).put((Object)SpawnerStats.REQ_PLAYER_RANGE, (Object)16).build();

    public PresetSpawnerStats() {
        this(DEFAULT_STATS);
    }

    public void apply(ApothSpawnerTile entity) {
        for (Map.Entry<SpawnerStat<?>, Object> entry : this.stats.entrySet()) {
            SpawnerStat<?> stat = entry.getKey();
            Object value = entry.getValue();
            stat.setValue(entity, value);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected final ImmutableMap.Builder<SpawnerStat<?>, Object> stats = ImmutableMap.builder();

        public <T> Builder stat(SpawnerStat<T> stat, T value) {
            this.stats.put(stat, value);
            return this;
        }

        public PresetSpawnerStats build() {
            return new PresetSpawnerStats((Map<SpawnerStat<?>, Object>)this.stats.build());
        }
    }
}

