/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.animation.DarkTraderAnimation;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTrader;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class DarkTraderModel
extends HierarchicalModel<DarkTrader> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ForbiddenArcanus.location("dark_trader"), "main");
    private final ModelPart root;

    public DarkTraderModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition all = partDefinition.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)2.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 35).addBox(-3.0f, -3.0f, -2.5f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)).texOffs(29, 43).addBox(-3.0f, 0.0f, -2.5f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.5f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(24, 23).addBox(-3.0f, -7.0f, -5.0f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)2.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -7.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.3f)).texOffs(0, 16).addBox(-4.0f, -1.0f, -5.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(0, 0).addBox(-4.0f, -7.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-4.5f));
        head.addOrReplaceChild("lhorn_r1", CubeListBuilder.create().texOffs(64, 0).addBox(-1.0f, -2.5f, -6.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-5.5f, (float)2.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        head.addOrReplaceChild("rhorn_r1", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-2.0f, -2.5f, -6.0f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-5.5f, (float)2.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(26, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-5.0f));
        PartDefinition moustache = head.addOrReplaceChild("moustache", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-5.0f));
        PartDefinition right = moustache.addOrReplaceChild("right", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        right.addOrReplaceChild("rmoustache_r1", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition left = moustache.addOrReplaceChild("left", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        left.addOrReplaceChild("lmoustache_r1", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition backpack = body.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(92, 24).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(118, 3).addBox(-7.0f, 3.0f, 0.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(118, 3).addBox(6.0f, 3.0f, 0.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(96, 38).addBox(-6.0f, 3.0f, 6.0f, 12.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        backpack.addOrReplaceChild("1_r1", CubeListBuilder.create().texOffs(72, 0).addBox(-8.0f, -12.0f, 0.0f, 16.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(46, 36).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.3f)).texOffs(46, 25).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)-6.5f, (float)-2.0f));
        body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(58, 36).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.3f)).texOffs(58, 25).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-6.5f, (float)-2.0f));
        PartDefinition rightleg = all.addOrReplaceChild("rightleg", CubeListBuilder.create(), PartPose.offset((float)-1.5f, (float)-6.0f, (float)-1.5f));
        rightleg.addOrReplaceChild("0_r1", CubeListBuilder.create().texOffs(0, 25).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = all.addOrReplaceChild("leftleg", CubeListBuilder.create(), PartPose.offset((float)1.5f, (float)-6.0f, (float)-1.5f));
        leftleg.addOrReplaceChild("0_r2", CubeListBuilder.create().texOffs(12, 25).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 34).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(@NotNull DarkTrader entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.spawnAnimationState, DarkTraderAnimation.SPAWN, ageInTicks);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

