/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.mojang.serialization.MapCodec;
import com.stal111.forbidden_arcanus.core.init.world.ModConfiguredFeatures;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import org.jetbrains.annotations.NotNull;

public class GrowingEdelwoodBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<GrowingEdelwoodBlock> CODEC = GrowingEdelwoodBlock.simpleCodec(GrowingEdelwoodBlock::new);
    private static final float BONEMEAL_CHANCE = 0.45f;
    private static final int REQUIRED_BRIGHTNESS = 9;
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public GrowingEdelwoodBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public void randomTick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextInt(7) == 0) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            this.growEdelwood(level, pos, state, random);
        }
    }

    public void growEdelwood(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Holder holder = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(ModConfiguredFeatures.EDELWOOD).orElse(null);
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)holder);
        if (event.isCanceled() || event.getFeature() == null) {
            return;
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
        if (!((ConfiguredFeature)event.getFeature().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos)) {
            level.setBlock(pos, state, 4);
        }
    }

    public boolean isValidBonemealTarget(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, @Nonnull RandomSource random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return level.getRandom().nextFloat() < 0.45f;
    }

    public void performBonemeal(@Nonnull ServerLevel level, @Nonnull RandomSource random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.growEdelwood(level, pos, state, random);
    }
}

